package physx.vehicle2;

import physx.NativeObject;

public class BaseVehicleState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static BaseVehicleState wrapPointer(long address) {
        return address != 0L ? new BaseVehicleState(address) : null;
    }
    
    public static BaseVehicleState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected BaseVehicleState(long address) {
        super(address);
    }

    // Constructors

    public BaseVehicleState() {
        address = _BaseVehicleState();
    }
    private static native long _BaseVehicleState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getBrakeCommandResponseStates(int index) {
        checkNotNull();
        return _getBrakeCommandResponseStates(address, index);
    }
    private static native float _getBrakeCommandResponseStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setBrakeCommandResponseStates(int index, float value) {
        checkNotNull();
        _setBrakeCommandResponseStates(address, index, value);
    }
    private static native void _setBrakeCommandResponseStates(long address, int index, float value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getSteerCommandResponseStates(int index) {
        checkNotNull();
        return _getSteerCommandResponseStates(address, index);
    }
    private static native float _getSteerCommandResponseStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setSteerCommandResponseStates(int index, float value) {
        checkNotNull();
        _setSteerCommandResponseStates(address, index, value);
    }
    private static native void _setSteerCommandResponseStates(long address, int index, float value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleWheelActuationState} [Value]
     */
    public PxVehicleWheelActuationState getActuationStates(int index) {
        checkNotNull();
        return PxVehicleWheelActuationState.wrapPointer(_getActuationStates(address, index));
    }
    private static native long _getActuationStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleWheelActuationState} [Value]
     */
    public void setActuationStates(int index, PxVehicleWheelActuationState value) {
        checkNotNull();
        _setActuationStates(address, index, value.getAddress());
    }
    private static native void _setActuationStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleRoadGeometryState} [Value]
     */
    public PxVehicleRoadGeometryState getRoadGeomStates(int index) {
        checkNotNull();
        return PxVehicleRoadGeometryState.wrapPointer(_getRoadGeomStates(address, index));
    }
    private static native long _getRoadGeomStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleRoadGeometryState} [Value]
     */
    public void setRoadGeomStates(int index, PxVehicleRoadGeometryState value) {
        checkNotNull();
        _setRoadGeomStates(address, index, value.getAddress());
    }
    private static native void _setRoadGeomStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleSuspensionState} [Value]
     */
    public PxVehicleSuspensionState getSuspensionStates(int index) {
        checkNotNull();
        return PxVehicleSuspensionState.wrapPointer(_getSuspensionStates(address, index));
    }
    private static native long _getSuspensionStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleSuspensionState} [Value]
     */
    public void setSuspensionStates(int index, PxVehicleSuspensionState value) {
        checkNotNull();
        _setSuspensionStates(address, index, value.getAddress());
    }
    private static native void _setSuspensionStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleSuspensionComplianceState} [Value]
     */
    public PxVehicleSuspensionComplianceState getSuspensionComplianceStates(int index) {
        checkNotNull();
        return PxVehicleSuspensionComplianceState.wrapPointer(_getSuspensionComplianceStates(address, index));
    }
    private static native long _getSuspensionComplianceStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleSuspensionComplianceState} [Value]
     */
    public void setSuspensionComplianceStates(int index, PxVehicleSuspensionComplianceState value) {
        checkNotNull();
        _setSuspensionComplianceStates(address, index, value.getAddress());
    }
    private static native void _setSuspensionComplianceStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleSuspensionForce} [Value]
     */
    public PxVehicleSuspensionForce getSuspensionForces(int index) {
        checkNotNull();
        return PxVehicleSuspensionForce.wrapPointer(_getSuspensionForces(address, index));
    }
    private static native long _getSuspensionForces(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleSuspensionForce} [Value]
     */
    public void setSuspensionForces(int index, PxVehicleSuspensionForce value) {
        checkNotNull();
        _setSuspensionForces(address, index, value.getAddress());
    }
    private static native void _setSuspensionForces(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxVehicleAntiRollTorque} [Value]
     */
    public PxVehicleAntiRollTorque getAntiRollTorque() {
        checkNotNull();
        return PxVehicleAntiRollTorque.wrapPointer(_getAntiRollTorque(address));
    }
    private static native long _getAntiRollTorque(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleAntiRollTorque} [Value]
     */
    public void setAntiRollTorque(PxVehicleAntiRollTorque value) {
        checkNotNull();
        _setAntiRollTorque(address, value.getAddress());
    }
    private static native void _setAntiRollTorque(long address, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleTireGripState} [Value]
     */
    public PxVehicleTireGripState getTireGripStates(int index) {
        checkNotNull();
        return PxVehicleTireGripState.wrapPointer(_getTireGripStates(address, index));
    }
    private static native long _getTireGripStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleTireGripState} [Value]
     */
    public void setTireGripStates(int index, PxVehicleTireGripState value) {
        checkNotNull();
        _setTireGripStates(address, index, value.getAddress());
    }
    private static native void _setTireGripStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleTireDirectionState} [Value]
     */
    public PxVehicleTireDirectionState getTireDirectionStates(int index) {
        checkNotNull();
        return PxVehicleTireDirectionState.wrapPointer(_getTireDirectionStates(address, index));
    }
    private static native long _getTireDirectionStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleTireDirectionState} [Value]
     */
    public void setTireDirectionStates(int index, PxVehicleTireDirectionState value) {
        checkNotNull();
        _setTireDirectionStates(address, index, value.getAddress());
    }
    private static native void _setTireDirectionStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleTireSpeedState} [Value]
     */
    public PxVehicleTireSpeedState getTireSpeedStates(int index) {
        checkNotNull();
        return PxVehicleTireSpeedState.wrapPointer(_getTireSpeedStates(address, index));
    }
    private static native long _getTireSpeedStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleTireSpeedState} [Value]
     */
    public void setTireSpeedStates(int index, PxVehicleTireSpeedState value) {
        checkNotNull();
        _setTireSpeedStates(address, index, value.getAddress());
    }
    private static native void _setTireSpeedStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleTireSlipState} [Value]
     */
    public PxVehicleTireSlipState getTireSlipStates(int index) {
        checkNotNull();
        return PxVehicleTireSlipState.wrapPointer(_getTireSlipStates(address, index));
    }
    private static native long _getTireSlipStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleTireSlipState} [Value]
     */
    public void setTireSlipStates(int index, PxVehicleTireSlipState value) {
        checkNotNull();
        _setTireSlipStates(address, index, value.getAddress());
    }
    private static native void _setTireSlipStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleTireCamberAngleState} [Value]
     */
    public PxVehicleTireCamberAngleState getTireCamberAngleStates(int index) {
        checkNotNull();
        return PxVehicleTireCamberAngleState.wrapPointer(_getTireCamberAngleStates(address, index));
    }
    private static native long _getTireCamberAngleStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleTireCamberAngleState} [Value]
     */
    public void setTireCamberAngleStates(int index, PxVehicleTireCamberAngleState value) {
        checkNotNull();
        _setTireCamberAngleStates(address, index, value.getAddress());
    }
    private static native void _setTireCamberAngleStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleTireStickyState} [Value]
     */
    public PxVehicleTireStickyState getTireStickyStates(int index) {
        checkNotNull();
        return PxVehicleTireStickyState.wrapPointer(_getTireStickyStates(address, index));
    }
    private static native long _getTireStickyStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleTireStickyState} [Value]
     */
    public void setTireStickyStates(int index, PxVehicleTireStickyState value) {
        checkNotNull();
        _setTireStickyStates(address, index, value.getAddress());
    }
    private static native void _setTireStickyStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleTireForce} [Value]
     */
    public PxVehicleTireForce getTireForces(int index) {
        checkNotNull();
        return PxVehicleTireForce.wrapPointer(_getTireForces(address, index));
    }
    private static native long _getTireForces(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleTireForce} [Value]
     */
    public void setTireForces(int index, PxVehicleTireForce value) {
        checkNotNull();
        _setTireForces(address, index, value.getAddress());
    }
    private static native void _setTireForces(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleWheelRigidBody1dState} [Value]
     */
    public PxVehicleWheelRigidBody1dState getWheelRigidBody1dStates(int index) {
        checkNotNull();
        return PxVehicleWheelRigidBody1dState.wrapPointer(_getWheelRigidBody1dStates(address, index));
    }
    private static native long _getWheelRigidBody1dStates(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleWheelRigidBody1dState} [Value]
     */
    public void setWheelRigidBody1dStates(int index, PxVehicleWheelRigidBody1dState value) {
        checkNotNull();
        _setWheelRigidBody1dStates(address, index, value.getAddress());
    }
    private static native void _setWheelRigidBody1dStates(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVehicleWheelLocalPose} [Value]
     */
    public PxVehicleWheelLocalPose getWheelLocalPoses(int index) {
        checkNotNull();
        return PxVehicleWheelLocalPose.wrapPointer(_getWheelLocalPoses(address, index));
    }
    private static native long _getWheelLocalPoses(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVehicleWheelLocalPose} [Value]
     */
    public void setWheelLocalPoses(int index, PxVehicleWheelLocalPose value) {
        checkNotNull();
        _setWheelLocalPoses(address, index, value.getAddress());
    }
    private static native void _setWheelLocalPoses(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxVehicleRigidBodyState} [Value]
     */
    public PxVehicleRigidBodyState getRigidBodyState() {
        checkNotNull();
        return PxVehicleRigidBodyState.wrapPointer(_getRigidBodyState(address));
    }
    private static native long _getRigidBodyState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleRigidBodyState} [Value]
     */
    public void setRigidBodyState(PxVehicleRigidBodyState value) {
        checkNotNull();
        _setRigidBodyState(address, value.getAddress());
    }
    private static native void _setRigidBodyState(long address, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
