package physx.vehicle2;

import physx.NativeObject;

public class BaseVehicle extends NativeObject {

    protected BaseVehicle() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static BaseVehicle wrapPointer(long address) {
        return address != 0L ? new BaseVehicle(address) : null;
    }
    
    public static BaseVehicle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected BaseVehicle(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link BaseVehicleParams} [Value]
     */
    public BaseVehicleParams getBaseParams() {
        checkNotNull();
        return BaseVehicleParams.wrapPointer(_getBaseParams(address));
    }
    private static native long _getBaseParams(long address);

    /**
     * @param value WebIDL type: {@link BaseVehicleParams} [Value]
     */
    public void setBaseParams(BaseVehicleParams value) {
        checkNotNull();
        _setBaseParams(address, value.getAddress());
    }
    private static native void _setBaseParams(long address, long value);

    /**
     * @return WebIDL type: {@link BaseVehicleState} [Value]
     */
    public BaseVehicleState getBaseState() {
        checkNotNull();
        return BaseVehicleState.wrapPointer(_getBaseState(address));
    }
    private static native long _getBaseState(long address);

    /**
     * @param value WebIDL type: {@link BaseVehicleState} [Value]
     */
    public void setBaseState(BaseVehicleState value) {
        checkNotNull();
        _setBaseState(address, value.getAddress());
    }
    private static native void _setBaseState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleComponentSequence} [Value]
     */
    public PxVehicleComponentSequence getComponentSequence() {
        checkNotNull();
        return PxVehicleComponentSequence.wrapPointer(_getComponentSequence(address));
    }
    private static native long _getComponentSequence(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleComponentSequence} [Value]
     */
    public void setComponentSequence(PxVehicleComponentSequence value) {
        checkNotNull();
        _setComponentSequence(address, value.getAddress());
    }
    private static native void _setComponentSequence(long address, long value);

    /**
     * @return WebIDL type: octet
     */
    public byte getComponentSequenceSubstepGroupHandle() {
        checkNotNull();
        return _getComponentSequenceSubstepGroupHandle(address);
    }
    private static native byte _getComponentSequenceSubstepGroupHandle(long address);

    /**
     * @param value WebIDL type: octet
     */
    public void setComponentSequenceSubstepGroupHandle(byte value) {
        checkNotNull();
        _setComponentSequenceSubstepGroupHandle(address, value);
    }
    private static native void _setComponentSequenceSubstepGroupHandle(long address, byte value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean initialize() {
        checkNotNull();
        return _initialize(address);
    }
    private static native boolean _initialize(long address);

    public void destroyState() {
        checkNotNull();
        _destroyState(address);
    }
    private static native void _destroyState(long address);

    /**
     * @param addPhysXBeginEndComponents WebIDL type: boolean
     */
    public void initComponentSequence(boolean addPhysXBeginEndComponents) {
        checkNotNull();
        _initComponentSequence(address, addPhysXBeginEndComponents);
    }
    private static native void _initComponentSequence(long address, boolean addPhysXBeginEndComponents);

    /**
     * @param dt      WebIDL type: float
     * @param context WebIDL type: {@link PxVehicleSimulationContext} [Const, Ref]
     */
    public void step(float dt, PxVehicleSimulationContext context) {
        checkNotNull();
        _step(address, dt, context.getAddress());
    }
    private static native void _step(long address, float dt, long context);

}
