package physx.support;

import physx.NativeObject;

public class PxTypedStridedData_PxU16 extends NativeObject {

    protected PxTypedStridedData_PxU16() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTypedStridedData_PxU16 wrapPointer(long address) {
        return address != 0L ? new PxTypedStridedData_PxU16(address) : null;
    }
    
    public static PxTypedStridedData_PxU16 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTypedStridedData_PxU16(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getStride() {
        checkNotNull();
        return _getStride(address);
    }
    private static native int _getStride(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setStride(int value) {
        checkNotNull();
        _setStride(address, value);
    }
    private static native void _setStride(long address, int value);

    /**
     * @return WebIDL type: {@link PxU16ConstPtr} [Value]
     */
    public PxU16ConstPtr getData() {
        checkNotNull();
        return PxU16ConstPtr.wrapPointer(_getData(address));
    }
    private static native long _getData(long address);

    /**
     * @param value WebIDL type: {@link PxU16ConstPtr} [Value]
     */
    public void setData(PxU16ConstPtr value) {
        checkNotNull();
        _setData(address, value.getAddress());
    }
    private static native void _setData(long address, long value);

}
