package physx.physics;

import physx.NativeObject;

/**
 * Descriptor for a broken constraint.
 * <p>
 * An array of these structs gets passed to the PxSimulationEventCallback::onConstraintBreak() report.
 * @see PxConstraint
 */
public class PxConstraintInfo extends NativeObject {

    protected PxConstraintInfo() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxConstraintInfo wrapPointer(long address) {
        return address != 0L ? new PxConstraintInfo(address) : null;
    }
    
    public static PxConstraintInfo arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxConstraintInfo(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The broken constraint.
     */
    public PxConstraint getConstraint() {
        checkNotNull();
        return PxConstraint.wrapPointer(_getConstraint(address));
    }
    private static native long _getConstraint(long address);

    /**
     * The broken constraint.
     */
    public void setConstraint(PxConstraint value) {
        checkNotNull();
        _setConstraint(address, value.getAddress());
    }
    private static native void _setConstraint(long address, long value);

    /**
     * The external object which owns the constraint (see #PxConstraintConnector::getExternalReference())
     */
    public NativeObject getExternalReference() {
        checkNotNull();
        return NativeObject.wrapPointer(_getExternalReference(address));
    }
    private static native long _getExternalReference(long address);

    /**
     * The external object which owns the constraint (see #PxConstraintConnector::getExternalReference())
     */
    public void setExternalReference(NativeObject value) {
        checkNotNull();
        _setExternalReference(address, value.getAddress());
    }
    private static native void _setExternalReference(long address, long value);

    /**
     * Unique type ID of the external object. Allows to cast the provided external reference to the appropriate type
     */
    public int getType() {
        checkNotNull();
        return _getType(address);
    }
    private static native int _getType(long address);

    /**
     * Unique type ID of the external object. Allows to cast the provided external reference to the appropriate type
     */
    public void setType(int value) {
        checkNotNull();
        _setType(address, value);
    }
    private static native void _setType(long address, int value);

}
