package physx.physics;

import physx.NativeObject;

/**
 * Defines the low/high limits of the length of a tendon.
 */
public class PxArticulationTendonLimit extends NativeObject {

    protected PxArticulationTendonLimit() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArticulationTendonLimit wrapPointer(long address) {
        return address != 0L ? new PxArticulationTendonLimit(address) : null;
    }
    
    public static PxArticulationTendonLimit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArticulationTendonLimit(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public float getLowLimit() {
        checkNotNull();
        return _getLowLimit(address);
    }
    private static native float _getLowLimit(long address);

    /**
     */
    public void setLowLimit(float value) {
        checkNotNull();
        _setLowLimit(address, value);
    }
    private static native void _setLowLimit(long address, float value);

    /**
     */
    public float getHighLimit() {
        checkNotNull();
        return _getHighLimit(address);
    }
    private static native float _getHighLimit(long address);

    /**
     */
    public void setHighLimit(float value) {
        checkNotNull();
        _setHighLimit(address, value);
    }
    private static native void _setHighLimit(long address, float value);

}
