package physx.particles;

import physx.PlatformChecks;
import physx.common.CUstream;

public class PxParticleSystemCallbackImpl extends PxParticleSystemCallback {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSystemCallbackImpl");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleSystemCallbackImpl wrapPointer(long address) {
        return address != 0L ? new PxParticleSystemCallbackImpl(address) : null;
    }
    
    public static PxParticleSystemCallbackImpl arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleSystemCallbackImpl(long address) {
        super(address);
    }

    protected PxParticleSystemCallbackImpl() {
        address = _PxParticleSystemCallbackImpl();
    }
    private native long _PxParticleSystemCallbackImpl();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private void _onBegin(long gpuParticleSystem, long stream) {
        onBegin(PxGpuMirroredGpuParticleSystemPointer.wrapPointer(gpuParticleSystem), CUstream.wrapPointer(stream));
    }

    /**
     * @param gpuParticleSystem WebIDL type: {@link PxGpuMirroredGpuParticleSystemPointer} [Const, Ref]
     * @param stream            WebIDL type: {@link CUstream} [Value]
     */
    public void onBegin(PxGpuMirroredGpuParticleSystemPointer gpuParticleSystem, CUstream stream) { }

    /*
     * Called from native code
     */
    private void _onAdvance(long gpuParticleSystem, long stream) {
        onAdvance(PxGpuMirroredGpuParticleSystemPointer.wrapPointer(gpuParticleSystem), CUstream.wrapPointer(stream));
    }

    /**
     * @param gpuParticleSystem WebIDL type: {@link PxGpuMirroredGpuParticleSystemPointer} [Const, Ref]
     * @param stream            WebIDL type: {@link CUstream} [Value]
     */
    public void onAdvance(PxGpuMirroredGpuParticleSystemPointer gpuParticleSystem, CUstream stream) { }

    /*
     * Called from native code
     */
    private void _onPostSolve(long gpuParticleSystem, long stream) {
        onPostSolve(PxGpuMirroredGpuParticleSystemPointer.wrapPointer(gpuParticleSystem), CUstream.wrapPointer(stream));
    }

    /**
     * @param gpuParticleSystem WebIDL type: {@link PxGpuMirroredGpuParticleSystemPointer} [Const, Ref]
     * @param stream            WebIDL type: {@link CUstream} [Value]
     */
    public void onPostSolve(PxGpuMirroredGpuParticleSystemPointer gpuParticleSystem, CUstream stream) { }

}
