package physx.particles;

public enum PxParticleSolverTypeEnum {

    ePBD(getePBD());
    public final int value;
    
    PxParticleSolverTypeEnum(int value) {
        this.value = value;
    }

    private static native int _getePBD();
    private static int getePBD() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleSolverTypeEnum");
        return _getePBD();
    }

    public static PxParticleSolverTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxParticleSolverTypeEnum: " + value);
    }

}
