package physx.particles;

import physx.PlatformChecks;
import physx.common.PxVec4;

public class PxParticleRigidAttachment extends PxParticleRigidFilterPair {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleRigidAttachment");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleRigidAttachment wrapPointer(long address) {
        return address != 0L ? new PxParticleRigidAttachment(address) : null;
    }
    
    public static PxParticleRigidAttachment arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleRigidAttachment(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleRigidAttachment
     */
    public static PxParticleRigidAttachment createAt(long address) {
        __placement_new_PxParticleRigidAttachment(address);
        PxParticleRigidAttachment createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleRigidAttachment
     */
    public static <T> PxParticleRigidAttachment createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleRigidAttachment(address);
        PxParticleRigidAttachment createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleRigidAttachment(long address);

    // Constructors

    public PxParticleRigidAttachment() {
        address = _PxParticleRigidAttachment();
    }
    private static native long _PxParticleRigidAttachment();

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec4} [Value]
     */
    public PxVec4 getMLocalPose0() {
        checkNotNull();
        return PxVec4.wrapPointer(_getMLocalPose0(address));
    }
    private static native long _getMLocalPose0(long address);

    /**
     * @param value WebIDL type: {@link PxVec4} [Value]
     */
    public void setMLocalPose0(PxVec4 value) {
        checkNotNull();
        _setMLocalPose0(address, value.getAddress());
    }
    private static native void _setMLocalPose0(long address, long value);

    /**
     * @return WebIDL type: {@link PxConeLimitParams} [Value]
     */
    public PxConeLimitParams getMConeLimitParams() {
        checkNotNull();
        return PxConeLimitParams.wrapPointer(_getMConeLimitParams(address));
    }
    private static native long _getMConeLimitParams(long address);

    /**
     * @param value WebIDL type: {@link PxConeLimitParams} [Value]
     */
    public void setMConeLimitParams(PxConeLimitParams value) {
        checkNotNull();
        _setMConeLimitParams(address, value.getAddress());
    }
    private static native void _setMConeLimitParams(long address, long value);

}
