package physx.particles;

import physx.PlatformChecks;
import physx.physics.PxBaseMaterial;

public class PxParticleMaterial extends PxBaseMaterial {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleMaterial");
    }

    protected PxParticleMaterial() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleMaterial wrapPointer(long address) {
        return address != 0L ? new PxParticleMaterial(address) : null;
    }
    
    public static PxParticleMaterial arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleMaterial(long address) {
        super(address);
    }

    // Functions

    /**
     * @param friction WebIDL type: float
     */
    public void setFriction(float friction) {
        checkNotNull();
        _setFriction(address, friction);
    }
    private static native void _setFriction(long address, float friction);

    /**
     * @return WebIDL type: float
     */
    public float getFriction() {
        checkNotNull();
        return _getFriction(address);
    }
    private static native float _getFriction(long address);

    /**
     * @param damping WebIDL type: float
     */
    public void setDamping(float damping) {
        checkNotNull();
        _setDamping(address, damping);
    }
    private static native void _setDamping(long address, float damping);

    /**
     * @return WebIDL type: float
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     * @param adhesion WebIDL type: float
     */
    public void setAdhesion(float adhesion) {
        checkNotNull();
        _setAdhesion(address, adhesion);
    }
    private static native void _setAdhesion(long address, float adhesion);

    /**
     * @return WebIDL type: float
     */
    public float getAdhesion() {
        checkNotNull();
        return _getAdhesion(address);
    }
    private static native float _getAdhesion(long address);

    /**
     * @param scale WebIDL type: float
     */
    public void setGravityScale(float scale) {
        checkNotNull();
        _setGravityScale(address, scale);
    }
    private static native void _setGravityScale(long address, float scale);

    /**
     * @return WebIDL type: float
     */
    public float getGravityScale() {
        checkNotNull();
        return _getGravityScale(address);
    }
    private static native float _getGravityScale(long address);

    /**
     * @param scale WebIDL type: float
     */
    public void setAdhesionRadiusScale(float scale) {
        checkNotNull();
        _setAdhesionRadiusScale(address, scale);
    }
    private static native void _setAdhesionRadiusScale(long address, float scale);

    /**
     * @return WebIDL type: float
     */
    public float getAdhesionRadiusScale() {
        checkNotNull();
        return _getAdhesionRadiusScale(address);
    }
    private static native float _getAdhesionRadiusScale(long address);

}
