package physx.particles;

/**
 * Flags which control the behaviour of a particle system.
 * <p>
 * See #PxPBDParticleSystem::setParticleFlag(), #PxPBDParticleSystem::setParticleFlags(), #PxPBDParticleSystem::getParticleFlags()
 */
public enum PxParticleFlagEnum {

    /**
     * Disables particle self-collision
     */
    eDISABLE_SELF_COLLISION(geteDISABLE_SELF_COLLISION()),
    /**
     * Disables particle-rigid body collision
     */
    eDISABLE_RIGID_COLLISION(geteDISABLE_RIGID_COLLISION()),
    /**
     * Enables full advection of diffuse particles. By default, diffuse particles are advected only by particles in the cell they are contained. This flag enables full neighbourhood generation (more expensive).
     */
    eFULL_DIFFUSE_ADVECTION(geteFULL_DIFFUSE_ADVECTION());
    public final int value;
    
    PxParticleFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteDISABLE_SELF_COLLISION();
    private static int geteDISABLE_SELF_COLLISION() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleFlagEnum");
        return _geteDISABLE_SELF_COLLISION();
    }

    private static native int _geteDISABLE_RIGID_COLLISION();
    private static int geteDISABLE_RIGID_COLLISION() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleFlagEnum");
        return _geteDISABLE_RIGID_COLLISION();
    }

    private static native int _geteFULL_DIFFUSE_ADVECTION();
    private static int geteFULL_DIFFUSE_ADVECTION() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.particles.PxParticleFlagEnum");
        return _geteFULL_DIFFUSE_ADVECTION();
    }

    public static PxParticleFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxParticleFlagEnum: " + value);
    }

}
