package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxParticleClothPreProcessor extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleClothPreProcessor");
    }

    protected PxParticleClothPreProcessor() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleClothPreProcessor wrapPointer(long address) {
        return address != 0L ? new PxParticleClothPreProcessor(address) : null;
    }
    
    public static PxParticleClothPreProcessor arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleClothPreProcessor(long address) {
        super(address);
    }

    // Functions

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @param clothDesc WebIDL type: {@link PxParticleClothDesc} [Const, Ref]
     * @param output    WebIDL type: {@link PxPartitionedParticleCloth} [Ref]
     */
    public void partitionSprings(PxParticleClothDesc clothDesc, PxPartitionedParticleCloth output) {
        checkNotNull();
        _partitionSprings(address, clothDesc.getAddress(), output.getAddress());
    }
    private static native void _partitionSprings(long address, long clothDesc, long output);

}
