package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxArray_PxParticleSpring extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxArray_PxParticleSpring");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArray_PxParticleSpring wrapPointer(long address) {
        return address != 0L ? new PxArray_PxParticleSpring(address) : null;
    }
    
    public static PxArray_PxParticleSpring arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArray_PxParticleSpring(long address) {
        super(address);
    }

    // Constructors

    public PxArray_PxParticleSpring() {
        address = _PxArray_PxParticleSpring();
    }
    private static native long _PxArray_PxParticleSpring();

    /**
     * @param size WebIDL type: unsigned long
     */
    public PxArray_PxParticleSpring(int size) {
        address = _PxArray_PxParticleSpring(size);
    }
    private static native long _PxArray_PxParticleSpring(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxParticleSpring} [Ref]
     */
    public PxParticleSpring get(int index) {
        checkNotNull();
        return PxParticleSpring.wrapPointer(_get(address, index));
    }
    private static native long _get(long address, int index);

    /**
     * @param index WebIDL type: unsigned long
     * @param value WebIDL type: {@link PxParticleSpring} [Const, Ref]
     */
    public void set(int index, PxParticleSpring value) {
        checkNotNull();
        _set(address, index, value.getAddress());
    }
    private static native void _set(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxParticleSpring}
     */
    public PxParticleSpring begin() {
        checkNotNull();
        return PxParticleSpring.wrapPointer(_begin(address));
    }
    private static native long _begin(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxParticleSpring} [Ref]
     */
    public void pushBack(PxParticleSpring value) {
        checkNotNull();
        _pushBack(address, value.getAddress());
    }
    private static native void _pushBack(long address, long value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
