package physx.geometry;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxBounds3;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxMassProperties;
import physx.physics.PxGeomRaycastHit;
import physx.physics.PxGeomSweepHit;
import physx.physics.PxHitFlags;

public class SimpleCustomGeometryCallbacks extends NativeObject {

    static {
        PlatformChecks.requirePlatform(15, "physx.geometry.SimpleCustomGeometryCallbacks");
    }

    protected SimpleCustomGeometryCallbacks() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static SimpleCustomGeometryCallbacks wrapPointer(long address) {
        return address != 0L ? new SimpleCustomGeometryCallbacks(address) : null;
    }
    
    public static SimpleCustomGeometryCallbacks arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected SimpleCustomGeometryCallbacks(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getPersistentContactManifold_outBreakingThreshold() {
        checkNotNull();
        return _getPersistentContactManifold_outBreakingThreshold(address);
    }
    private static native float _getPersistentContactManifold_outBreakingThreshold(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setPersistentContactManifold_outBreakingThreshold(float value) {
        checkNotNull();
        _setPersistentContactManifold_outBreakingThreshold(address, value);
    }
    private static native void _setPersistentContactManifold_outBreakingThreshold(long address, float value);

    // Functions

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @return WebIDL type: {@link PxBounds3}
     */
    public PxBounds3 getLocalBoundsImpl(PxGeometry geometry) {
        checkNotNull();
        return PxBounds3.wrapPointer(_getLocalBoundsImpl(address, geometry.getAddress()));
    }
    private static native long _getLocalBoundsImpl(long address, long geometry);

    /**
     * @param geom0             WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param geom1             WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose0             WebIDL type: {@link PxTransform} [Const, Ref]
     * @param pose1             WebIDL type: {@link PxTransform} [Const, Ref]
     * @param contactDistance   WebIDL type: float
     * @param meshContactMargin WebIDL type: float
     * @param toleranceLength   WebIDL type: float
     * @param contactBuffer     WebIDL type: {@link PxContactBuffer} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean generateContactsImpl(PxGeometry geom0, PxGeometry geom1, PxTransform pose0, PxTransform pose1, float contactDistance, float meshContactMargin, float toleranceLength, PxContactBuffer contactBuffer) {
        checkNotNull();
        return _generateContactsImpl(address, geom0.getAddress(), geom1.getAddress(), pose0.getAddress(), pose1.getAddress(), contactDistance, meshContactMargin, toleranceLength, contactBuffer.getAddress());
    }
    private static native boolean _generateContactsImpl(long address, long geom0, long geom1, long pose0, long pose1, float contactDistance, float meshContactMargin, float toleranceLength, long contactBuffer);

    /**
     * @param origin   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param geom     WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param maxDist  WebIDL type: float
     * @param hitFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param maxHits  WebIDL type: unsigned long
     * @param rayHits  WebIDL type: {@link PxGeomRaycastHit}
     * @param stride   WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int raycastImpl(PxVec3 origin, PxVec3 unitDir, PxGeometry geom, PxTransform pose, float maxDist, PxHitFlags hitFlags, int maxHits, PxGeomRaycastHit rayHits, int stride) {
        checkNotNull();
        return _raycastImpl(address, origin.getAddress(), unitDir.getAddress(), geom.getAddress(), pose.getAddress(), maxDist, hitFlags.getAddress(), maxHits, rayHits.getAddress(), stride);
    }
    private static native int _raycastImpl(long address, long origin, long unitDir, long geom, long pose, float maxDist, long hitFlags, int maxHits, long rayHits, int stride);

    /**
     * @param geom0 WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose0 WebIDL type: {@link PxTransform} [Const, Ref]
     * @param geom1 WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose1 WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean overlapImpl(PxGeometry geom0, PxTransform pose0, PxGeometry geom1, PxTransform pose1) {
        checkNotNull();
        return _overlapImpl(address, geom0.getAddress(), pose0.getAddress(), geom1.getAddress(), pose1.getAddress());
    }
    private static native boolean _overlapImpl(long address, long geom0, long pose0, long geom1, long pose1);

    /**
     * @param unitDir   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param maxDist   WebIDL type: float
     * @param geom0     WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose0     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param geom1     WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose1     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param sweepHit  WebIDL type: {@link PxGeomSweepHit} [Ref]
     * @param hitFlags  WebIDL type: {@link PxHitFlags} [Ref]
     * @param inflation WebIDL type: float
     * @return WebIDL type: boolean
     */
    public boolean sweepImpl(PxVec3 unitDir, float maxDist, PxGeometry geom0, PxTransform pose0, PxGeometry geom1, PxTransform pose1, PxGeomSweepHit sweepHit, PxHitFlags hitFlags, float inflation) {
        checkNotNull();
        return _sweepImpl(address, unitDir.getAddress(), maxDist, geom0.getAddress(), pose0.getAddress(), geom1.getAddress(), pose1.getAddress(), sweepHit.getAddress(), hitFlags.getAddress(), inflation);
    }
    private static native boolean _sweepImpl(long address, long unitDir, float maxDist, long geom0, long pose0, long geom1, long pose1, long sweepHit, long hitFlags, float inflation);

    /**
     * @param geometry       WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param massProperties WebIDL type: {@link PxMassProperties} [Ref]
     */
    public void computeMassPropertiesImpl(PxGeometry geometry, PxMassProperties massProperties) {
        checkNotNull();
        _computeMassPropertiesImpl(address, geometry.getAddress(), massProperties.getAddress());
    }
    private static native void _computeMassPropertiesImpl(long address, long geometry, long massProperties);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean usePersistentContactManifoldImpl(PxGeometry geometry) {
        checkNotNull();
        return _usePersistentContactManifoldImpl(address, geometry.getAddress());
    }
    private static native boolean _usePersistentContactManifoldImpl(long address, long geometry);

}
