package physx.geometry;

/**
 * These flags indicate what kind of deficiencies a tetrahedron mesh has and describe if the mesh is considered ok, problematic or invalid for softbody cooking
 */
public enum PxTetrahedronMeshAnalysisResultEnum {

    eVALID(geteVALID()),
    /**
     * At least one tetrahedron has zero or negative volume. This can happen when the input triangle mesh contains triangles that are very elongated, e. g. one edge is a lot shorther than the other two.
     */
    eDEGENERATE_TETRAHEDRON(geteDEGENERATE_TETRAHEDRON()),
    /**
     * flag is set if the mesh is categorized as problematic
     */
    eMESH_IS_PROBLEMATIC(geteMESH_IS_PROBLEMATIC()),
    eMESH_IS_INVALID(geteMESH_IS_INVALID());
    public final int value;
    
    PxTetrahedronMeshAnalysisResultEnum(int value) {
        this.value = value;
    }

    private static native int _geteVALID();
    private static int geteVALID() {
        de.fabmax.physxjni.Loader.load();
        return _geteVALID();
    }

    private static native int _geteDEGENERATE_TETRAHEDRON();
    private static int geteDEGENERATE_TETRAHEDRON() {
        de.fabmax.physxjni.Loader.load();
        return _geteDEGENERATE_TETRAHEDRON();
    }

    private static native int _geteMESH_IS_PROBLEMATIC();
    private static int geteMESH_IS_PROBLEMATIC() {
        de.fabmax.physxjni.Loader.load();
        return _geteMESH_IS_PROBLEMATIC();
    }

    private static native int _geteMESH_IS_INVALID();
    private static int geteMESH_IS_INVALID() {
        de.fabmax.physxjni.Loader.load();
        return _geteMESH_IS_INVALID();
    }

    public static PxTetrahedronMeshAnalysisResultEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxTetrahedronMeshAnalysisResultEnum: " + value);
    }

}
