package physx.extensions;

import physx.NativeObject;

public class PxSphericalJointFlags extends NativeObject {

    protected PxSphericalJointFlags() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSphericalJointFlags wrapPointer(long address) {
        return address != 0L ? new PxSphericalJointFlags(address) : null;
    }
    
    public static PxSphericalJointFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSphericalJointFlags(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: unsigned short
     * @return Stack allocated object of PxSphericalJointFlags
     */
    public static PxSphericalJointFlags createAt(long address, short flags) {
        __placement_new_PxSphericalJointFlags(address, flags);
        PxSphericalJointFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: unsigned short
     * @return Stack allocated object of PxSphericalJointFlags
     */
    public static <T> PxSphericalJointFlags createAt(T allocator, Allocator<T> allocate, short flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxSphericalJointFlags(address, flags);
        PxSphericalJointFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxSphericalJointFlags(long address, short flags);

    // Constructors

    /**
     * @param flags WebIDL type: unsigned short
     */
    public PxSphericalJointFlags(short flags) {
        address = _PxSphericalJointFlags(flags);
    }
    private static native long _PxSphericalJointFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxSphericalJointFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxSphericalJointFlagEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxSphericalJointFlagEnum} [enum]
     */
    public void raise(PxSphericalJointFlagEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxSphericalJointFlagEnum} [enum]
     */
    public void clear(PxSphericalJointFlagEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
