package physx.extensions;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxGjkQueryRaycastResult extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxGjkQueryRaycastResult wrapPointer(long address) {
        return address != 0L ? new PxGjkQueryRaycastResult(address) : null;
    }
    
    public static PxGjkQueryRaycastResult arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxGjkQueryRaycastResult(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxGjkQueryRaycastResult
     */
    public static PxGjkQueryRaycastResult createAt(long address) {
        __placement_new_PxGjkQueryRaycastResult(address);
        PxGjkQueryRaycastResult createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxGjkQueryRaycastResult
     */
    public static <T> PxGjkQueryRaycastResult createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxGjkQueryRaycastResult(address);
        PxGjkQueryRaycastResult createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxGjkQueryRaycastResult(long address);

    // Constructors

    public PxGjkQueryRaycastResult() {
        address = _PxGjkQueryRaycastResult();
    }
    private static native long _PxGjkQueryRaycastResult();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: boolean
     */
    public boolean getSuccess() {
        checkNotNull();
        return _getSuccess(address);
    }
    private static native boolean _getSuccess(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setSuccess(boolean value) {
        checkNotNull();
        _setSuccess(address, value);
    }
    private static native void _setSuccess(long address, boolean value);

    /**
     * @return WebIDL type: float
     */
    public float getT() {
        checkNotNull();
        return _getT(address);
    }
    private static native float _getT(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setT(float value) {
        checkNotNull();
        _setT(address, value);
    }
    private static native void _setT(long address, float value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getN() {
        checkNotNull();
        return PxVec3.wrapPointer(_getN(address));
    }
    private static native long _getN(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setN(PxVec3 value) {
        checkNotNull();
        _setN(address, value.getAddress());
    }
    private static native void _setN(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getP() {
        checkNotNull();
        return PxVec3.wrapPointer(_getP(address));
    }
    private static native long _getP(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setP(PxVec3 value) {
        checkNotNull();
        _setP(address, value.getAddress());
    }
    private static native void _setP(long address, long value);

}
