package physx.extensions;

import physx.NativeObject;
import physx.common.PxPlane;
import physx.physics.PxFilterData;
import physx.physics.PxMaterial;
import physx.physics.PxPhysics;
import physx.physics.PxRigidStatic;

public class PxExtensionTopLevelFunctions extends NativeObject {

    protected PxExtensionTopLevelFunctions() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxExtensionTopLevelFunctions wrapPointer(long address) {
        return address != 0L ? new PxExtensionTopLevelFunctions(address) : null;
    }
    
    public static PxExtensionTopLevelFunctions arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxExtensionTopLevelFunctions(long address) {
        super(address);
    }

    // Functions

    /**
     * @param sdk        WebIDL type: {@link PxPhysics} [Ref]
     * @param plane      WebIDL type: {@link PxPlane} [Const, Ref]
     * @param material   WebIDL type: {@link PxMaterial} [Ref]
     * @param filterData WebIDL type: {@link PxFilterData} [Const, Ref]
     * @return WebIDL type: {@link PxRigidStatic}
     */
    public static PxRigidStatic CreatePlane(PxPhysics sdk, PxPlane plane, PxMaterial material, PxFilterData filterData) {
        return PxRigidStatic.wrapPointer(_CreatePlane(sdk.getAddress(), plane.getAddress(), material.getAddress(), filterData.getAddress()));
    }
    private static native long _CreatePlane(long sdk, long plane, long material, long filterData);

}
