package physx.extensions;

import physx.NativeObject;
import physx.common.PxOutputStream;

/**
 * default implementation of a memory write stream
 * @see physx.common.PxOutputStream
 */
public class PxDefaultMemoryOutputStream extends PxOutputStream {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxDefaultMemoryOutputStream wrapPointer(long address) {
        return address != 0L ? new PxDefaultMemoryOutputStream(address) : null;
    }
    
    public static PxDefaultMemoryOutputStream arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxDefaultMemoryOutputStream(long address) {
        super(address);
    }

    // Constructors

    public PxDefaultMemoryOutputStream() {
        address = _PxDefaultMemoryOutputStream();
    }
    private static native long _PxDefaultMemoryOutputStream();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param src   WebIDL type: VoidPtr
     * @param count WebIDL type: unsigned long
     */
    public void write(NativeObject src, int count) {
        checkNotNull();
        _write(address, src.getAddress(), count);
    }
    private static native void _write(long address, long src, int count);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSize() {
        checkNotNull();
        return _getSize(address);
    }
    private static native int _getSize(long address);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getData(address));
    }
    private static native long _getData(long address);

}
