package physx.extensions;

import physx.common.PxVec3;

public class CustomSupportImpl extends CustomSupport {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static CustomSupportImpl wrapPointer(long address) {
        return address != 0L ? new CustomSupportImpl(address) : null;
    }
    
    public static CustomSupportImpl arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected CustomSupportImpl(long address) {
        super(address);
    }

    protected CustomSupportImpl() {
        address = _CustomSupportImpl();
    }
    private native long _CustomSupportImpl();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private float _getCustomMargin() {
        return getCustomMargin();
    }

    /**
     * @return WebIDL type: float
     */
    public float getCustomMargin() {
        return 0.0f;
    }

    /*
     * Called from native code
     */
    private void _getCustomSupportLocal(long dir, long result) {
        getCustomSupportLocal(PxVec3.wrapPointer(dir), PxVec3.wrapPointer(result));
    }

    /**
     * @param dir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param result WebIDL type: {@link PxVec3} [Ref]
     */
    public void getCustomSupportLocal(PxVec3 dir, PxVec3 result) { }

}
