package physx.common;

import physx.NativeObject;

/**
 * Interface for points, lines, triangles, and text buffer.
 */
public class PxRenderBuffer extends NativeObject {

    protected PxRenderBuffer() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRenderBuffer wrapPointer(long address) {
        return address != 0L ? new PxRenderBuffer(address) : null;
    }
    
    public static PxRenderBuffer arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRenderBuffer(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbPoints() {
        checkNotNull();
        return _getNbPoints(address);
    }
    private static native int _getNbPoints(long address);

    /**
     * @return WebIDL type: {@link PxDebugPoint} [Const]
     */
    public PxDebugPoint getPoints() {
        checkNotNull();
        return PxDebugPoint.wrapPointer(_getPoints(address));
    }
    private static native long _getPoints(long address);

    /**
     * @param point WebIDL type: {@link PxDebugPoint} [Const, Ref]
     */
    public void addPoint(PxDebugPoint point) {
        checkNotNull();
        _addPoint(address, point.getAddress());
    }
    private static native void _addPoint(long address, long point);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbLines() {
        checkNotNull();
        return _getNbLines(address);
    }
    private static native int _getNbLines(long address);

    /**
     * @return WebIDL type: {@link PxDebugLine} [Const]
     */
    public PxDebugLine getLines() {
        checkNotNull();
        return PxDebugLine.wrapPointer(_getLines(address));
    }
    private static native long _getLines(long address);

    /**
     * @param line WebIDL type: {@link PxDebugLine} [Const, Ref]
     */
    public void addLine(PxDebugLine line) {
        checkNotNull();
        _addLine(address, line.getAddress());
    }
    private static native void _addLine(long address, long line);

    /**
     * @param nbLines WebIDL type: unsigned long [Const]
     * @return WebIDL type: {@link PxDebugLine}
     */
    public PxDebugLine reserveLines(int nbLines) {
        checkNotNull();
        return PxDebugLine.wrapPointer(_reserveLines(address, nbLines));
    }
    private static native long _reserveLines(long address, int nbLines);

    /**
     * @param nbLines WebIDL type: unsigned long [Const]
     * @return WebIDL type: {@link PxDebugPoint}
     */
    public PxDebugPoint reservePoints(int nbLines) {
        checkNotNull();
        return PxDebugPoint.wrapPointer(_reservePoints(address, nbLines));
    }
    private static native long _reservePoints(long address, int nbLines);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTriangles() {
        checkNotNull();
        return _getNbTriangles(address);
    }
    private static native int _getNbTriangles(long address);

    /**
     * @return WebIDL type: {@link PxDebugTriangle} [Const]
     */
    public PxDebugTriangle getTriangles() {
        checkNotNull();
        return PxDebugTriangle.wrapPointer(_getTriangles(address));
    }
    private static native long _getTriangles(long address);

    /**
     * @param triangle WebIDL type: {@link PxDebugTriangle} [Const, Ref]
     */
    public void addTriangle(PxDebugTriangle triangle) {
        checkNotNull();
        _addTriangle(address, triangle.getAddress());
    }
    private static native void _addTriangle(long address, long triangle);

    /**
     * @param other WebIDL type: {@link PxRenderBuffer} [Const, Ref]
     */
    public void append(PxRenderBuffer other) {
        checkNotNull();
        _append(address, other.getAddress());
    }
    private static native void _append(long address, long other);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

    /**
     * @param delta WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void shift(PxVec3 delta) {
        checkNotNull();
        _shift(address, delta.getAddress());
    }
    private static native void _shift(long address, long delta);

    /**
     * @return WebIDL type: boolean
     */
    public boolean empty() {
        checkNotNull();
        return _empty(address);
    }
    private static native boolean _empty(long address);

}
