package physx.common;


/**
 * Base class for ref-counted objects.
 */
public class PxRefCounted extends PxBase {

    protected PxRefCounted() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRefCounted wrapPointer(long address) {
        return address != 0L ? new PxRefCounted(address) : null;
    }
    
    public static PxRefCounted arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRefCounted(long address) {
        super(address);
    }

    // Functions

    /**
     * Returns the reference count of the object.
     * <p>
     * At creation, the reference count of the object is 1. Every other object referencing this object increments the
     * count by 1. When the reference count reaches 0, and only then, the object gets destroyed automatically.
     * @return the current reference count.
     */
    public int getReferenceCount() {
        checkNotNull();
        return _getReferenceCount(address);
    }
    private static native int _getReferenceCount(long address);

    /**
     * Acquires a counted reference to this object.
     * <p>
     * This method increases the reference count of the object by 1. Decrement the reference count by calling release()
     */
    public void acquireReference() {
        checkNotNull();
        _acquireReference(address);
    }
    private static native void _acquireReference(long address);

}
