package physx.character;


/**
 * Box character controller.
 * @see PxBoxControllerDesc
 * @see PxController
 */
public class PxBoxController extends PxController {

    protected PxBoxController() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBoxController wrapPointer(long address) {
        return address != 0L ? new PxBoxController(address) : null;
    }
    
    public static PxBoxController arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBoxController(long address) {
        super(address);
    }

    // Functions

    /**
     * Gets controller's half height.
     * @return The half height of the controller.
     * @see #setHalfHeight
     */
    public float getHalfHeight() {
        checkNotNull();
        return _getHalfHeight(address);
    }
    private static native float _getHalfHeight(long address);

    /**
     * Gets controller's half side extent.
     * @return The half side extent of the controller.
     * @see #setHalfSideExtent
     */
    public float getHalfSideExtent() {
        checkNotNull();
        return _getHalfSideExtent(address);
    }
    private static native float _getHalfSideExtent(long address);

    /**
     * Gets controller's half forward extent.
     * @return The half forward extent of the controller.
     * @see #setHalfForwardExtent
     */
    public float getHalfForwardExtent() {
        checkNotNull();
        return _getHalfForwardExtent(address);
    }
    private static native float _getHalfForwardExtent(long address);

    /**
     * Sets controller's half height.
     * <p>
     * \warning this doesn't check for collisions.
     * @param halfHeight The new half height for the controller.
     * @return Currently always true.
     * @see #getHalfHeight
     */
    public boolean setHalfHeight(float halfHeight) {
        checkNotNull();
        return _setHalfHeight(address, halfHeight);
    }
    private static native boolean _setHalfHeight(long address, float halfHeight);

    /**
     * Sets controller's half side extent.
     * <p>
     * \warning this doesn't check for collisions.
     * @param halfSideExtent The new half side extent for the controller.
     * @return Currently always true.
     * @see #getHalfSideExtent
     */
    public boolean setHalfSideExtent(float halfSideExtent) {
        checkNotNull();
        return _setHalfSideExtent(address, halfSideExtent);
    }
    private static native boolean _setHalfSideExtent(long address, float halfSideExtent);

    /**
     * Sets controller's half forward extent.
     * <p>
     * \warning this doesn't check for collisions.
     * @param halfForwardExtent The new half forward extent for the controller.
     * @return Currently always true.
     * @see #getHalfForwardExtent
     */
    public boolean setHalfForwardExtent(float halfForwardExtent) {
        checkNotNull();
        return _setHalfForwardExtent(address, halfForwardExtent);
    }
    private static native boolean _setHalfForwardExtent(long address, float halfForwardExtent);

}
