package physx.vehicle2;

import physx.NativeObject;

/**
 * Tire slip values are computed using ratios with potential for divide-by-zero errors. PxVehicleTireSlipParams
 * introduces a minimum value for the denominator of each of these ratios.
 */
public class PxVehicleTireSlipParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireSlipParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireSlipParams(address) : null;
    }
    
    public static PxVehicleTireSlipParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireSlipParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleTireSlipParams
     */
    public static PxVehicleTireSlipParams createAt(long address) {
        __placement_new_PxVehicleTireSlipParams(address);
        PxVehicleTireSlipParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleTireSlipParams
     */
    public static <T> PxVehicleTireSlipParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleTireSlipParams(address);
        PxVehicleTireSlipParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleTireSlipParams(long address);

    // Constructors

    public PxVehicleTireSlipParams() {
        address = _PxVehicleTireSlipParams();
    }
    private static native long _PxVehicleTireSlipParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The lateral slip angle is typically computed as a function of the ratio of lateral and longitudinal speeds
     * of the rigid body in the tire's frame. This leads to a divide-by-zero in the event that the longitudinal speed
     * approaches zero. The parameter minLatSlipDenominator sets a minimum denominator for the ratio of speeds used to
     * compute the lateral slip angle.
     * <b>Note:</b> Larger timesteps typically require larger values of minLatSlipDenominator.
     * <p>
     * <b>Range:</b> (0, inf)<br>
     * <b>Unit:</b> velocity = length / time
     */
    public float getMinLatSlipDenominator() {
        checkNotNull();
        return _getMinLatSlipDenominator(address);
    }
    private static native float _getMinLatSlipDenominator(long address);

    /**
     * The lateral slip angle is typically computed as a function of the ratio of lateral and longitudinal speeds
     * of the rigid body in the tire's frame. This leads to a divide-by-zero in the event that the longitudinal speed
     * approaches zero. The parameter minLatSlipDenominator sets a minimum denominator for the ratio of speeds used to
     * compute the lateral slip angle.
     * <b>Note:</b> Larger timesteps typically require larger values of minLatSlipDenominator.
     * <p>
     * <b>Range:</b> (0, inf)<br>
     * <b>Unit:</b> velocity = length / time
     */
    public void setMinLatSlipDenominator(float value) {
        checkNotNull();
        _setMinLatSlipDenominator(address, value);
    }
    private static native void _setMinLatSlipDenominator(long address, float value);

    /**
     * The longitudinal slip represents the difference between the longitudinal speed of the rigid body in the tire's
     * frame and the linear speed arising from the rotation of the wheel. This is typically normalized using the reciprocal
     * of the longitudinal speed of the rigid body in the tire's frame. This leads to a divide-by-zero in the event that the
     * longitudinal speed approaches zero. The parameter minPassiveLongSlipDenominator sets a minimum denominator for the normalized
     * longitudinal slip when the wheel experiences zero drive torque and zero brake torque and zero handbrake torque. The aim is
     * to bring the vehicle to rest without experiencing wheel rotational speeds that oscillate around zero.
     * <b>Note:</b> The vehicle will come to rest more smoothly with larger values of minPassiveLongSlipDenominator, particularly
     * with large timesteps that often lead to oscillation in wheel rotation speeds when the wheel rotation speed approaches
     * zero.
     * <b>Note:</b> It is recommended that minActiveLongSlipDenominator &lt; minPassiveLongSlipDenominator.
     * <p>
     * <b>Range:</b> (0, inf)<br>
     * <b>Unit:</b> velocity = length / time
     */
    public float getMinPassiveLongSlipDenominator() {
        checkNotNull();
        return _getMinPassiveLongSlipDenominator(address);
    }
    private static native float _getMinPassiveLongSlipDenominator(long address);

    /**
     * The longitudinal slip represents the difference between the longitudinal speed of the rigid body in the tire's
     * frame and the linear speed arising from the rotation of the wheel. This is typically normalized using the reciprocal
     * of the longitudinal speed of the rigid body in the tire's frame. This leads to a divide-by-zero in the event that the
     * longitudinal speed approaches zero. The parameter minPassiveLongSlipDenominator sets a minimum denominator for the normalized
     * longitudinal slip when the wheel experiences zero drive torque and zero brake torque and zero handbrake torque. The aim is
     * to bring the vehicle to rest without experiencing wheel rotational speeds that oscillate around zero.
     * <b>Note:</b> The vehicle will come to rest more smoothly with larger values of minPassiveLongSlipDenominator, particularly
     * with large timesteps that often lead to oscillation in wheel rotation speeds when the wheel rotation speed approaches
     * zero.
     * <b>Note:</b> It is recommended that minActiveLongSlipDenominator &lt; minPassiveLongSlipDenominator.
     * <p>
     * <b>Range:</b> (0, inf)<br>
     * <b>Unit:</b> velocity = length / time
     */
    public void setMinPassiveLongSlipDenominator(float value) {
        checkNotNull();
        _setMinPassiveLongSlipDenominator(address, value);
    }
    private static native void _setMinPassiveLongSlipDenominator(long address, float value);

    /**
     * The longitudinal slip represents the difference between the longitudinal speed of the rigid body in the tire's
     * frame and the linear speed arising from the rotation of the wheel. This is typically normalized using the reciprocal
     * of the longitudinal speed of the rigid body in the tire's frame. This leads to a divide-by-zero in the event that the
     * longitudinal speed approaches zero. The parameter minActiveLongSlipDenominator sets a minimum denominator for the normalized
     * longitudinal slip when the wheel experiences either a non-zero drive torque or a non-zero brake torque or a non-zero handbrake
     * torque.
     * <b>Note:</b> Larger timesteps typically require larger values of minActiveLongSlipDenominator to avoid instabilities occurring when
     * the vehicle is aggressively throttled from rest.
     * <b>Note:</b> It is recommended that minActiveLongSlipDenominator &lt; minPassiveLongSlipDenominator.
     * <p>
     * <b>Range:</b> (0, inf)<br>
     * <b>Unit:</b> velocity = length / time
     */
    public float getMinActiveLongSlipDenominator() {
        checkNotNull();
        return _getMinActiveLongSlipDenominator(address);
    }
    private static native float _getMinActiveLongSlipDenominator(long address);

    /**
     * The longitudinal slip represents the difference between the longitudinal speed of the rigid body in the tire's
     * frame and the linear speed arising from the rotation of the wheel. This is typically normalized using the reciprocal
     * of the longitudinal speed of the rigid body in the tire's frame. This leads to a divide-by-zero in the event that the
     * longitudinal speed approaches zero. The parameter minActiveLongSlipDenominator sets a minimum denominator for the normalized
     * longitudinal slip when the wheel experiences either a non-zero drive torque or a non-zero brake torque or a non-zero handbrake
     * torque.
     * <b>Note:</b> Larger timesteps typically require larger values of minActiveLongSlipDenominator to avoid instabilities occurring when
     * the vehicle is aggressively throttled from rest.
     * <b>Note:</b> It is recommended that minActiveLongSlipDenominator &lt; minPassiveLongSlipDenominator.
     * <p>
     * <b>Range:</b> (0, inf)<br>
     * <b>Unit:</b> velocity = length / time
     */
    public void setMinActiveLongSlipDenominator(float value) {
        checkNotNull();
        _setMinActiveLongSlipDenominator(address, value);
    }
    private static native void _setMinActiveLongSlipDenominator(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleTireSlipParams} [Value]
     */
    public PxVehicleTireSlipParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleTireSlipParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
