package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

/**
 * PxVehiclePhysXConstraintState is a data structure used to write 
 * constraint data to the internal state of the associated PxScene.
 */
public class PxVehiclePhysXConstraintState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXConstraintState wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXConstraintState(address) : null;
    }
    
    public static PxVehiclePhysXConstraintState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXConstraintState(long address) {
        super(address);
    }

    // Constructors

    public PxVehiclePhysXConstraintState() {
        address = _PxVehiclePhysXConstraintState();
    }
    private static native long _PxVehiclePhysXConstraintState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: boolean
     */
    public boolean getTireActiveStatus(int index) {
        checkNotNull();
        return _getTireActiveStatus(address, index);
    }
    private static native boolean _getTireActiveStatus(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: boolean
     */
    public void setTireActiveStatus(int index, boolean value) {
        checkNotNull();
        _setTireActiveStatus(address, index, value);
    }
    private static native void _setTireActiveStatus(long address, int index, boolean value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTireLinears(int index) {
        checkNotNull();
        return PxVec3.wrapPointer(_getTireLinears(address, index));
    }
    private static native long _getTireLinears(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTireLinears(int index, PxVec3 value) {
        checkNotNull();
        _setTireLinears(address, index, value.getAddress());
    }
    private static native void _setTireLinears(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTireAngulars(int index) {
        checkNotNull();
        return PxVec3.wrapPointer(_getTireAngulars(address, index));
    }
    private static native long _getTireAngulars(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTireAngulars(int index, PxVec3 value) {
        checkNotNull();
        _setTireAngulars(address, index, value.getAddress());
    }
    private static native void _setTireAngulars(long address, int index, long value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getTireDamping(int index) {
        checkNotNull();
        return _getTireDamping(address, index);
    }
    private static native float _getTireDamping(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setTireDamping(int index, float value) {
        checkNotNull();
        _setTireDamping(address, index, value);
    }
    private static native void _setTireDamping(long address, int index, float value);

    /**
     * a boolean describing whether to trigger a suspension limit constraint.
     */
    public boolean getSuspActiveStatus() {
        checkNotNull();
        return _getSuspActiveStatus(address);
    }
    private static native boolean _getSuspActiveStatus(long address);

    /**
     * a boolean describing whether to trigger a suspension limit constraint.
     */
    public void setSuspActiveStatus(boolean value) {
        checkNotNull();
        _setSuspActiveStatus(address, value);
    }
    private static native void _setSuspActiveStatus(long address, boolean value);

    /**
     * linear component of velocity jacobian in the world frame.
     */
    public PxVec3 getSuspLinear() {
        checkNotNull();
        return PxVec3.wrapPointer(_getSuspLinear(address));
    }
    private static native long _getSuspLinear(long address);

    /**
     * linear component of velocity jacobian in the world frame.
     */
    public void setSuspLinear(PxVec3 value) {
        checkNotNull();
        _setSuspLinear(address, value.getAddress());
    }
    private static native void _setSuspLinear(long address, long value);

    /**
     * angular component of velocity jacobian in the world frame.
     */
    public PxVec3 getSuspAngular() {
        checkNotNull();
        return PxVec3.wrapPointer(_getSuspAngular(address));
    }
    private static native long _getSuspAngular(long address);

    /**
     * angular component of velocity jacobian in the world frame.
     */
    public void setSuspAngular(PxVec3 value) {
        checkNotNull();
        _setSuspAngular(address, value.getAddress());
    }
    private static native void _setSuspAngular(long address, long value);

    /**
     * the excess suspension compression to be resolved by the constraint that cannot be resolved due to the travel limit
     * of the suspension spring.
     * <p>
     * <b>Note:</b> The expected error value is the excess suspension compression projected onto the ground plane normal and should have
     *       a negative sign.
     */
    public float getSuspGeometricError() {
        checkNotNull();
        return _getSuspGeometricError(address);
    }
    private static native float _getSuspGeometricError(long address);

    /**
     * the excess suspension compression to be resolved by the constraint that cannot be resolved due to the travel limit
     * of the suspension spring.
     * <p>
     * <b>Note:</b> The expected error value is the excess suspension compression projected onto the ground plane normal and should have
     *       a negative sign.
     */
    public void setSuspGeometricError(float value) {
        checkNotNull();
        _setSuspGeometricError(address, value);
    }
    private static native void _setSuspGeometricError(long address, float value);

    /**
     * restitution value of the restitution model used to generate a target velocity that will resolve the geometric error.
     * <b>Note:</b> A value of 0.0 means that the restitution model is not employed.
     */
    public float getRestitution() {
        checkNotNull();
        return _getRestitution(address);
    }
    private static native float _getRestitution(long address);

    /**
     * restitution value of the restitution model used to generate a target velocity that will resolve the geometric error.
     * <b>Note:</b> A value of 0.0 means that the restitution model is not employed.
     */
    public void setRestitution(float value) {
        checkNotNull();
        _setRestitution(address, value);
    }
    private static native void _setRestitution(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
