package physx.vehicle2;

import physx.NativeObject;
import physx.physics.PxRigidBody;
import physx.physics.PxShape;

/**
 * A description of the PhysX actor and shapes that represent the vehicle in an associated PxScene.
 */
public class PxVehiclePhysXActor extends NativeObject {

    protected PxVehiclePhysXActor() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXActor wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXActor(address) : null;
    }
    
    public static PxVehiclePhysXActor arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXActor(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The PhysX rigid body that represents the vehcle in the associated PhysX scene. 
     * <b>Note:</b> PxActorFlag::eDISABLE_GRAVITY must be set true on the PxRigidBody
     */
    public PxRigidBody getRigidBody() {
        checkNotNull();
        return PxRigidBody.wrapPointer(_getRigidBody(address));
    }
    private static native long _getRigidBody(long address);

    /**
     * The PhysX rigid body that represents the vehcle in the associated PhysX scene. 
     * <b>Note:</b> PxActorFlag::eDISABLE_GRAVITY must be set true on the PxRigidBody
     */
    public void setRigidBody(PxRigidBody value) {
        checkNotNull();
        _setRigidBody(address, value.getAddress());
    }
    private static native void _setRigidBody(long address, long value);

    /**
     * @param index Array index
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getWheelShapes(int index) {
        checkNotNull();
        return PxShape.wrapPointer(_getWheelShapes(address, index));
    }
    private static native long _getWheelShapes(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: {@link PxShape}
     */
    public void setWheelShapes(int index, PxShape value) {
        checkNotNull();
        _setWheelShapes(address, index, value.getAddress());
    }
    private static native void _setWheelShapes(long address, int index, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
