package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleGearboxState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleGearboxState wrapPointer(long address) {
        return address != 0L ? new PxVehicleGearboxState(address) : null;
    }
    
    public static PxVehicleGearboxState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleGearboxState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleGearboxState() {
        address = _PxVehicleGearboxState();
    }
    private static native long _PxVehicleGearboxState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Current gear
     */
    public int getCurrentGear() {
        checkNotNull();
        return _getCurrentGear(address);
    }
    private static native int _getCurrentGear(long address);

    /**
     * Current gear
     */
    public void setCurrentGear(int value) {
        checkNotNull();
        _setCurrentGear(address, value);
    }
    private static native void _setCurrentGear(long address, int value);

    /**
     * Target gear (different from current gear if a gear change is underway)
     */
    public int getTargetGear() {
        checkNotNull();
        return _getTargetGear(address);
    }
    private static native int _getTargetGear(long address);

    /**
     * Target gear (different from current gear if a gear change is underway)
     */
    public void setTargetGear(int value) {
        checkNotNull();
        _setTargetGear(address, value);
    }
    private static native void _setTargetGear(long address, int value);

    /**
     * Reported time that has passed since gear change started.
     * <p>
     * The special value PX_VEHICLE_NO_GEAR_SWITCH_PENDING denotes that there is currently
     * no gear change underway.
     * <p>
     * If a gear switch was initiated, the special value PX_VEHICLE_GEAR_SWITCH_INITIATED
     * will be used temporarily but get translated to 0 in the gearbox update immediately.
     * This state might only get encountered, if the vehicle component update is split into
     * multiple sequences that do not run in one go.
     * <p>
     * <b>Unit:</b> time
     */
    public float getGearSwitchTime() {
        checkNotNull();
        return _getGearSwitchTime(address);
    }
    private static native float _getGearSwitchTime(long address);

    /**
     * Reported time that has passed since gear change started.
     * <p>
     * The special value PX_VEHICLE_NO_GEAR_SWITCH_PENDING denotes that there is currently
     * no gear change underway.
     * <p>
     * If a gear switch was initiated, the special value PX_VEHICLE_GEAR_SWITCH_INITIATED
     * will be used temporarily but get translated to 0 in the gearbox update immediately.
     * This state might only get encountered, if the vehicle component update is split into
     * multiple sequences that do not run in one go.
     * <p>
     * <b>Unit:</b> time
     */
    public void setGearSwitchTime(float value) {
        checkNotNull();
        _setGearSwitchTime(address, value);
    }
    private static native void _setGearSwitchTime(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
