package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVehicleFixedSizeLookupTableVec3_3 extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleFixedSizeLookupTableVec3_3 wrapPointer(long address) {
        return address != 0L ? new PxVehicleFixedSizeLookupTableVec3_3(address) : null;
    }
    
    public static PxVehicleFixedSizeLookupTableVec3_3 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleFixedSizeLookupTableVec3_3(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleFixedSizeLookupTableVec3_3() {
        address = _PxVehicleFixedSizeLookupTableVec3_3();
    }
    private static native long _PxVehicleFixedSizeLookupTableVec3_3();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param x WebIDL type: float
     * @param y WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean addPair(float x, PxVec3 y) {
        checkNotNull();
        return _addPair(address, x, y.getAddress());
    }
    private static native boolean _addPair(long address, float x, long y);

    /**
     * @param x WebIDL type: float
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 interpolate(float x) {
        checkNotNull();
        return PxVec3.wrapPointer(_interpolate(address, x));
    }
    private static native long _interpolate(long address, float x);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
