package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleComponentSequence extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleComponentSequence wrapPointer(long address) {
        return address != 0L ? new PxVehicleComponentSequence(address) : null;
    }
    
    public static PxVehicleComponentSequence arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleComponentSequence(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleComponentSequence() {
        address = _PxVehicleComponentSequence();
    }
    private static native long _PxVehicleComponentSequence();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param component WebIDL type: {@link PxVehicleComponent}
     * @return WebIDL type: boolean
     */
    public boolean add(PxVehicleComponent component) {
        checkNotNull();
        return _add(address, component.getAddress());
    }
    private static native boolean _add(long address, long component);

    /**
     * @return WebIDL type: octet
     */
    public byte beginSubstepGroup() {
        checkNotNull();
        return _beginSubstepGroup(address);
    }
    private static native byte _beginSubstepGroup(long address);

    /**
     * @param nbSubSteps WebIDL type: octet
     * @return WebIDL type: octet
     */
    public byte beginSubstepGroup(byte nbSubSteps) {
        checkNotNull();
        return _beginSubstepGroup(address, nbSubSteps);
    }
    private static native byte _beginSubstepGroup(long address, byte nbSubSteps);

    public void endSubstepGroup() {
        checkNotNull();
        _endSubstepGroup(address);
    }
    private static native void _endSubstepGroup(long address);

    /**
     * @param subGroupHandle WebIDL type: octet
     * @param nbSteps        WebIDL type: octet
     */
    public void setSubsteps(byte subGroupHandle, byte nbSteps) {
        checkNotNull();
        _setSubsteps(address, subGroupHandle, nbSteps);
    }
    private static native void _setSubsteps(long address, byte subGroupHandle, byte nbSteps);

    /**
     * @param dt      WebIDL type: float
     * @param context WebIDL type: {@link PxVehicleSimulationContext} [Const, Ref]
     */
    public void update(float dt, PxVehicleSimulationContext context) {
        checkNotNull();
        _update(address, dt, context.getAddress());
    }
    private static native void _update(long address, float dt, long context);

}
