package physx.support;

import physx.physics.PxSimulationFilterShader;

public class PassThroughFilterShader extends PxSimulationFilterShader {

    protected PassThroughFilterShader() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PassThroughFilterShader wrapPointer(long address) {
        return address != 0L ? new PassThroughFilterShader(address) : null;
    }
    
    public static PassThroughFilterShader arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PassThroughFilterShader(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public int getOutputPairFlags() {
        checkNotNull();
        return _getOutputPairFlags(address);
    }
    private static native int _getOutputPairFlags(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setOutputPairFlags(int value) {
        checkNotNull();
        _setOutputPairFlags(address, value);
    }
    private static native void _setOutputPairFlags(long address, int value);

    // Functions

    /**
     * @param attributes0   WebIDL type: unsigned long
     * @param filterData0w0 WebIDL type: unsigned long
     * @param filterData0w1 WebIDL type: unsigned long
     * @param filterData0w2 WebIDL type: unsigned long
     * @param filterData0w3 WebIDL type: unsigned long
     * @param attributes1   WebIDL type: unsigned long
     * @param filterData1w0 WebIDL type: unsigned long
     * @param filterData1w1 WebIDL type: unsigned long
     * @param filterData1w2 WebIDL type: unsigned long
     * @param filterData1w3 WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int filterShader(int attributes0, int filterData0w0, int filterData0w1, int filterData0w2, int filterData0w3, int attributes1, int filterData1w0, int filterData1w1, int filterData1w2, int filterData1w3) {
        checkNotNull();
        return _filterShader(address, attributes0, filterData0w0, filterData0w1, filterData0w2, filterData0w3, attributes1, filterData1w0, filterData1w1, filterData1w2, filterData1w3);
    }
    private static native int _filterShader(long address, int attributes0, int filterData0w0, int filterData0w1, int filterData0w2, int filterData0w3, int attributes1, int filterData1w0, int filterData1w1, int filterData1w2, int filterData1w3);

}
