package physx.support;

import physx.NativeObject;
import physx.PlatformChecks;

public class OmniPvdFileWriteStream extends NativeObject {

    static {
        PlatformChecks.requirePlatform(7, "physx.support.OmniPvdFileWriteStream");
    }

    protected OmniPvdFileWriteStream() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static OmniPvdFileWriteStream wrapPointer(long address) {
        return address != 0L ? new OmniPvdFileWriteStream(address) : null;
    }
    
    public static OmniPvdFileWriteStream arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected OmniPvdFileWriteStream(long address) {
        super(address);
    }

    // Functions

    /**
     * @param fileName WebIDL type: DOMString
     */
    public void setFileName(String fileName) {
        checkNotNull();
        _setFileName(address, fileName);
    }
    private static native void _setFileName(long address, String fileName);

}
