package physx.physics;


public class PxRaycastHit extends PxGeomRaycastHit {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxRaycastHit wrapPointer(long address) {
        return address != 0L ? new PxRaycastHit(address) : null;
    }
    
    public static PxRaycastHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxRaycastHit(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxRaycastHit
     */
    public static PxRaycastHit createAt(long address) {
        __placement_new_PxRaycastHit(address);
        PxRaycastHit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxRaycastHit
     */
    public static <T> PxRaycastHit createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxRaycastHit(address);
        PxRaycastHit createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxRaycastHit(long address);

    // Constructors

    public PxRaycastHit() {
        address = _PxRaycastHit();
    }
    private static native long _PxRaycastHit();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxRigidActor}
     */
    public PxRigidActor getActor() {
        checkNotNull();
        return PxRigidActor.wrapPointer(_getActor(address));
    }
    private static native long _getActor(long address);

    /**
     * @param value WebIDL type: {@link PxRigidActor}
     */
    public void setActor(PxRigidActor value) {
        checkNotNull();
        _setActor(address, value.getAddress());
    }
    private static native void _setActor(long address, long value);

    /**
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getShape() {
        checkNotNull();
        return PxShape.wrapPointer(_getShape(address));
    }
    private static native long _getShape(long address);

    /**
     * @param value WebIDL type: {@link PxShape}
     */
    public void setShape(PxShape value) {
        checkNotNull();
        _setShape(address, value.getAddress());
    }
    private static native void _setShape(long address, long value);

}
