package physx.physics;

/**
 * Parameter to addForce() and addTorque() calls, determines the exact operation that is carried out.
 * <p>
 * <b>See also:</b> PxRigidBody.addForce() PxRigidBody.addTorque()
 */
public enum PxForceModeEnum {

    /**
     * parameter has unit of mass * length / time^2, i.e., a force
     */
    eFORCE(geteFORCE()),
    /**
     * parameter has unit of mass * length / time, i.e., force * time
     */
    eIMPULSE(geteIMPULSE()),
    /**
     * parameter has unit of length / time, i.e., the effect is mass independent: a velocity change.
     */
    eVELOCITY_CHANGE(geteVELOCITY_CHANGE()),
    eACCELERATION(geteACCELERATION());
    public final int value;
    
    PxForceModeEnum(int value) {
        this.value = value;
    }

    private static native int _geteFORCE();
    private static int geteFORCE() {
        de.fabmax.physxjni.Loader.load();
        return _geteFORCE();
    }

    private static native int _geteIMPULSE();
    private static int geteIMPULSE() {
        de.fabmax.physxjni.Loader.load();
        return _geteIMPULSE();
    }

    private static native int _geteVELOCITY_CHANGE();
    private static int geteVELOCITY_CHANGE() {
        de.fabmax.physxjni.Loader.load();
        return _geteVELOCITY_CHANGE();
    }

    private static native int _geteACCELERATION();
    private static int geteACCELERATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteACCELERATION();
    }

    public static PxForceModeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxForceModeEnum: " + value);
    }

}
