package physx.physics;

/**
 * constraint flags
 * <p>
 * <b>Note:</b> eBROKEN is a read only flag
 */
public enum PxConstraintFlagEnum {

    /**
     * whether the constraint is broken
     */
    eBROKEN(geteBROKEN()),
    /**
     * @deprecated whether actor1 should get projected to actor0 for this constraint (note: projection of a static/kinematic actor to a dynamic actor will be ignored)
     */
    @Deprecated
    ePROJECT_TO_ACTOR0(getePROJECT_TO_ACTOR0()),
    /**
     * @deprecated whether actor0 should get projected to actor1 for this constraint (note: projection of a static/kinematic actor to a dynamic actor will be ignored)
     */
    @Deprecated
    ePROJECT_TO_ACTOR1(getePROJECT_TO_ACTOR1()),
    /**
     * @deprecated whether the actors should get projected for this constraint (the direction will be chosen by PhysX)
     */
    @Deprecated
    ePROJECTION(getePROJECTION()),
    /**
     * whether contacts should be generated between the objects this constraint constrains
     */
    eCOLLISION_ENABLED(geteCOLLISION_ENABLED()),
    /**
     * whether this constraint should be visualized, if constraint visualization is turned on
     */
    eVISUALIZATION(geteVISUALIZATION()),
    /**
     * limits for drive strength are forces rather than impulses
     */
    eDRIVE_LIMITS_ARE_FORCES(geteDRIVE_LIMITS_ARE_FORCES()),
    /**
     * perform preprocessing for improved accuracy on D6 Slerp Drive (this flag will be removed in a future release when preprocessing is no longer required)
     */
    eIMPROVED_SLERP(geteIMPROVED_SLERP()),
    /**
     * suppress constraint preprocessing, intended for use with rowResponseThreshold. May result in worse solver accuracy for ill-conditioned constraints.
     */
    eDISABLE_PREPROCESSING(geteDISABLE_PREPROCESSING()),
    /**
     * enables extended limit ranges for angular limits (e.g., limit values &gt; PxPi or &lt; -PxPi)
     */
    eENABLE_EXTENDED_LIMITS(geteENABLE_EXTENDED_LIMITS()),
    /**
     * the constraint type is supported by gpu dynamics
     */
    eGPU_COMPATIBLE(geteGPU_COMPATIBLE());
    public final int value;
    
    PxConstraintFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteBROKEN();
    private static int geteBROKEN() {
        de.fabmax.physxjni.Loader.load();
        return _geteBROKEN();
    }

    private static native int _getePROJECT_TO_ACTOR0();
    private static int getePROJECT_TO_ACTOR0() {
        de.fabmax.physxjni.Loader.load();
        return _getePROJECT_TO_ACTOR0();
    }

    private static native int _getePROJECT_TO_ACTOR1();
    private static int getePROJECT_TO_ACTOR1() {
        de.fabmax.physxjni.Loader.load();
        return _getePROJECT_TO_ACTOR1();
    }

    private static native int _getePROJECTION();
    private static int getePROJECTION() {
        de.fabmax.physxjni.Loader.load();
        return _getePROJECTION();
    }

    private static native int _geteCOLLISION_ENABLED();
    private static int geteCOLLISION_ENABLED() {
        de.fabmax.physxjni.Loader.load();
        return _geteCOLLISION_ENABLED();
    }

    private static native int _geteVISUALIZATION();
    private static int geteVISUALIZATION() {
        de.fabmax.physxjni.Loader.load();
        return _geteVISUALIZATION();
    }

    private static native int _geteDRIVE_LIMITS_ARE_FORCES();
    private static int geteDRIVE_LIMITS_ARE_FORCES() {
        de.fabmax.physxjni.Loader.load();
        return _geteDRIVE_LIMITS_ARE_FORCES();
    }

    private static native int _geteIMPROVED_SLERP();
    private static int geteIMPROVED_SLERP() {
        de.fabmax.physxjni.Loader.load();
        return _geteIMPROVED_SLERP();
    }

    private static native int _geteDISABLE_PREPROCESSING();
    private static int geteDISABLE_PREPROCESSING() {
        de.fabmax.physxjni.Loader.load();
        return _geteDISABLE_PREPROCESSING();
    }

    private static native int _geteENABLE_EXTENDED_LIMITS();
    private static int geteENABLE_EXTENDED_LIMITS() {
        de.fabmax.physxjni.Loader.load();
        return _geteENABLE_EXTENDED_LIMITS();
    }

    private static native int _geteGPU_COMPATIBLE();
    private static int geteGPU_COMPATIBLE() {
        de.fabmax.physxjni.Loader.load();
        return _geteGPU_COMPATIBLE();
    }

    public static PxConstraintFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxConstraintFlagEnum: " + value);
    }

}
