package physx.physics;

/**
 * Flags to configure the forces reported by articulation link sensors.
 * <p>
 * <b>See also:</b> PxArticulationSensor::setFlag
 */
public enum PxArticulationSensorFlagEnum {

    /**
     * Raise to receive forces from forward dynamics.
     */
    eFORWARD_DYNAMICS_FORCES(geteFORWARD_DYNAMICS_FORCES()),
    /**
     * Raise to receive forces from constraint solver.
     */
    eCONSTRAINT_SOLVER_FORCES(geteCONSTRAINT_SOLVER_FORCES()),
    eWORLD_FRAME(geteWORLD_FRAME());
    public final int value;
    
    PxArticulationSensorFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteFORWARD_DYNAMICS_FORCES();
    private static int geteFORWARD_DYNAMICS_FORCES() {
        de.fabmax.physxjni.Loader.load();
        return _geteFORWARD_DYNAMICS_FORCES();
    }

    private static native int _geteCONSTRAINT_SOLVER_FORCES();
    private static int geteCONSTRAINT_SOLVER_FORCES() {
        de.fabmax.physxjni.Loader.load();
        return _geteCONSTRAINT_SOLVER_FORCES();
    }

    private static native int _geteWORLD_FRAME();
    private static int geteWORLD_FRAME() {
        de.fabmax.physxjni.Loader.load();
        return _geteWORLD_FRAME();
    }

    public static PxArticulationSensorFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxArticulationSensorFlagEnum: " + value);
    }

}
