package physx.physics;

/**
 * Identifies each type of actor.
 * <b>See also:</b> PxActor 
 */
public enum PxActorTypeEnum {

    /**
     * A static rigid body
     * <b>See also:</b> PxRigidStatic
     */
    eRIGID_STATIC(geteRIGID_STATIC()),
    /**
     * A dynamic rigid body
     * <b>See also:</b> PxRigidDynamic
     */
    eRIGID_DYNAMIC(geteRIGID_DYNAMIC()),
    /**
     * An articulation link
     * <b>See also:</b> PxArticulationLink
     */
    eARTICULATION_LINK(geteARTICULATION_LINK()),
    /**
     * A FEM-based soft body
     * <b>See also:</b> PxSoftBody
     */
    eSOFTBODY(geteSOFTBODY()),
    /**
     * A FEM-based cloth
     * <b>Note:</b> In development
     * <b>See also:</b> PxFEMCloth
     */
    eFEMCLOTH(geteFEMCLOTH()),
    /**
     * A PBD ParticleSystem
     * <b>See also:</b> PxPBDParticleSystem
     */
    ePBD_PARTICLESYSTEM(getePBD_PARTICLESYSTEM()),
    /**
     * A FLIP ParticleSystem
     * <b>Note:</b> In development
     * <b>See also:</b> PxFLIPParticleSystem
     */
    eFLIP_PARTICLESYSTEM(geteFLIP_PARTICLESYSTEM()),
    /**
     * A MPM ParticleSystem
     * <b>Note:</b> In development
     * <b>See also:</b> PxMPMParticleSystem
     */
    eMPM_PARTICLESYSTEM(geteMPM_PARTICLESYSTEM()),
    /**
     * A CUSTOM ParticleSystem
     * <b>Note:</b> In development
     * <b>See also:</b> PxCUSTOMParticleSystem
     */
    eCUSTOM_PARTICLESYSTEM(geteCUSTOM_PARTICLESYSTEM()),
    /**
     * A HairSystem
     * <b>Note:</b> In development
     * <b>See also:</b> PxHairSystem
     */
    eHAIRSYSTEM(geteHAIRSYSTEM());
    public final int value;
    
    PxActorTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteRIGID_STATIC();
    private static int geteRIGID_STATIC() {
        de.fabmax.physxjni.Loader.load();
        return _geteRIGID_STATIC();
    }

    private static native int _geteRIGID_DYNAMIC();
    private static int geteRIGID_DYNAMIC() {
        de.fabmax.physxjni.Loader.load();
        return _geteRIGID_DYNAMIC();
    }

    private static native int _geteARTICULATION_LINK();
    private static int geteARTICULATION_LINK() {
        de.fabmax.physxjni.Loader.load();
        return _geteARTICULATION_LINK();
    }

    private static native int _geteSOFTBODY();
    private static int geteSOFTBODY() {
        de.fabmax.physxjni.Loader.load();
        return _geteSOFTBODY();
    }

    private static native int _geteFEMCLOTH();
    private static int geteFEMCLOTH() {
        de.fabmax.physxjni.Loader.load();
        return _geteFEMCLOTH();
    }

    private static native int _getePBD_PARTICLESYSTEM();
    private static int getePBD_PARTICLESYSTEM() {
        de.fabmax.physxjni.Loader.load();
        return _getePBD_PARTICLESYSTEM();
    }

    private static native int _geteFLIP_PARTICLESYSTEM();
    private static int geteFLIP_PARTICLESYSTEM() {
        de.fabmax.physxjni.Loader.load();
        return _geteFLIP_PARTICLESYSTEM();
    }

    private static native int _geteMPM_PARTICLESYSTEM();
    private static int geteMPM_PARTICLESYSTEM() {
        de.fabmax.physxjni.Loader.load();
        return _geteMPM_PARTICLESYSTEM();
    }

    private static native int _geteCUSTOM_PARTICLESYSTEM();
    private static int geteCUSTOM_PARTICLESYSTEM() {
        de.fabmax.physxjni.Loader.load();
        return _geteCUSTOM_PARTICLESYSTEM();
    }

    private static native int _geteHAIRSYSTEM();
    private static int geteHAIRSYSTEM() {
        de.fabmax.physxjni.Loader.load();
        return _geteHAIRSYSTEM();
    }

    public static PxActorTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxActorTypeEnum: " + value);
    }

}
