package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxParticleFlags extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleFlags");
    }

    protected PxParticleFlags() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleFlags wrapPointer(long address) {
        return address != 0L ? new PxParticleFlags(address) : null;
    }
    
    public static PxParticleFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleFlags(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: unsigned long
     * @return Stack allocated object of PxParticleFlags
     */
    public static PxParticleFlags createAt(long address, int flags) {
        __placement_new_PxParticleFlags(address, flags);
        PxParticleFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: unsigned long
     * @return Stack allocated object of PxParticleFlags
     */
    public static <T> PxParticleFlags createAt(T allocator, Allocator<T> allocate, int flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleFlags(address, flags);
        PxParticleFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleFlags(long address, int flags);

    // Constructors

    /**
     * @param flags WebIDL type: unsigned long
     */
    public PxParticleFlags(int flags) {
        address = _PxParticleFlags(flags);
    }
    private static native long _PxParticleFlags(int flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxParticleFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxParticleFlagEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxParticleFlagEnum} [enum]
     */
    public void raise(PxParticleFlagEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxParticleFlagEnum} [enum]
     */
    public void clear(PxParticleFlagEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
