package physx.particles;

import physx.NativeObject;
import physx.PlatformChecks;

/**
 * Particle cloth structure. Holds information about a single piece of cloth that is part of a #PxParticleClothBuffer.
 */
public class PxParticleCloth extends NativeObject {

    static {
        PlatformChecks.requirePlatform(3, "physx.particles.PxParticleCloth");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxParticleCloth wrapPointer(long address) {
        return address != 0L ? new PxParticleCloth(address) : null;
    }
    
    public static PxParticleCloth arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxParticleCloth(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxParticleCloth
     */
    public static PxParticleCloth createAt(long address) {
        __placement_new_PxParticleCloth(address);
        PxParticleCloth createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxParticleCloth
     */
    public static <T> PxParticleCloth createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxParticleCloth(address);
        PxParticleCloth createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxParticleCloth(long address);

    // Constructors

    public PxParticleCloth() {
        address = _PxParticleCloth();
    }
    private static native long _PxParticleCloth();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Index of the first particle of this cloth in the position/velocity buffers of the parent #PxParticleClothBuffer
     */
    public int getStartVertexIndex() {
        checkNotNull();
        return _getStartVertexIndex(address);
    }
    private static native int _getStartVertexIndex(long address);

    /**
     * Index of the first particle of this cloth in the position/velocity buffers of the parent #PxParticleClothBuffer
     */
    public void setStartVertexIndex(int value) {
        checkNotNull();
        _setStartVertexIndex(address, value);
    }
    private static native void _setStartVertexIndex(long address, int value);

    /**
     * The number of particles of this piece of cloth
     */
    public int getNumVertices() {
        checkNotNull();
        return _getNumVertices(address);
    }
    private static native int _getNumVertices(long address);

    /**
     * The number of particles of this piece of cloth
     */
    public void setNumVertices(int value) {
        checkNotNull();
        _setNumVertices(address, value);
    }
    private static native void _setNumVertices(long address, int value);

    /**
     * Used internally.
     */
    public float getClothBlendScale() {
        checkNotNull();
        return _getClothBlendScale(address);
    }
    private static native float _getClothBlendScale(long address);

    /**
     * Used internally.
     */
    public void setClothBlendScale(float value) {
        checkNotNull();
        _setClothBlendScale(address, value);
    }
    private static native void _setClothBlendScale(long address, float value);

    /**
     * The rest volume of this piece of cloth, used for inflatable simulation.
     */
    public float getRestVolume() {
        checkNotNull();
        return _getRestVolume(address);
    }
    private static native float _getRestVolume(long address);

    /**
     * The rest volume of this piece of cloth, used for inflatable simulation.
     */
    public void setRestVolume(float value) {
        checkNotNull();
        _setRestVolume(address, value);
    }
    private static native void _setRestVolume(long address, float value);

    /**
     * The factor of the rest volume to specify the target volume for this piece of cloth, used for inflatable simulation.
     */
    public float getPressure() {
        checkNotNull();
        return _getPressure(address);
    }
    private static native float _getPressure(long address);

    /**
     * The factor of the rest volume to specify the target volume for this piece of cloth, used for inflatable simulation.
     */
    public void setPressure(float value) {
        checkNotNull();
        _setPressure(address, value);
    }
    private static native void _setPressure(long address, float value);

    /**
     * The index of the first triangle of this piece of cloth in the triangle list.
     */
    public int getStartTriangleIndex() {
        checkNotNull();
        return _getStartTriangleIndex(address);
    }
    private static native int _getStartTriangleIndex(long address);

    /**
     * The index of the first triangle of this piece of cloth in the triangle list.
     */
    public void setStartTriangleIndex(int value) {
        checkNotNull();
        _setStartTriangleIndex(address, value);
    }
    private static native void _setStartTriangleIndex(long address, int value);

    /**
     * The number of triangles of this piece of cloth.
     */
    public int getNumTriangles() {
        checkNotNull();
        return _getNumTriangles(address);
    }
    private static native int _getNumTriangles(long address);

    /**
     * The number of triangles of this piece of cloth.
     */
    public void setNumTriangles(int value) {
        checkNotNull();
        _setNumTriangles(address, value);
    }
    private static native void _setNumTriangles(long address, int value);

}
