package physx.geometry;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxContactPoint extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxContactPoint wrapPointer(long address) {
        return address != 0L ? new PxContactPoint(address) : null;
    }
    
    public static PxContactPoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxContactPoint(long address) {
        super(address);
    }

    // Constructors

    public PxContactPoint() {
        address = _PxContactPoint();
    }
    private static native long _PxContactPoint();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getNormal() {
        checkNotNull();
        return PxVec3.wrapPointer(_getNormal(address));
    }
    private static native long _getNormal(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setNormal(PxVec3 value) {
        checkNotNull();
        _setNormal(address, value.getAddress());
    }
    private static native void _setNormal(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getPoint() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPoint(address));
    }
    private static native long _getPoint(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setPoint(PxVec3 value) {
        checkNotNull();
        _setPoint(address, value.getAddress());
    }
    private static native void _setPoint(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTargetVel() {
        checkNotNull();
        return PxVec3.wrapPointer(_getTargetVel(address));
    }
    private static native long _getTargetVel(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setTargetVel(PxVec3 value) {
        checkNotNull();
        _setTargetVel(address, value.getAddress());
    }
    private static native void _setTargetVel(long address, long value);

    /**
     * The separation of the shapes at the contact point. A negative separation denotes a penetration.
     */
    public float getSeparation() {
        checkNotNull();
        return _getSeparation(address);
    }
    private static native float _getSeparation(long address);

    /**
     * The separation of the shapes at the contact point. A negative separation denotes a penetration.
     */
    public void setSeparation(float value) {
        checkNotNull();
        _setSeparation(address, value);
    }
    private static native void _setSeparation(long address, float value);

    /**
     * The max impulse permitted at this point
     */
    public float getMaxImpulse() {
        checkNotNull();
        return _getMaxImpulse(address);
    }
    private static native float _getMaxImpulse(long address);

    /**
     * The max impulse permitted at this point
     */
    public void setMaxImpulse(float value) {
        checkNotNull();
        _setMaxImpulse(address, value);
    }
    private static native void _setMaxImpulse(long address, float value);

    /**
     * The static friction coefficient
     */
    public float getStaticFriction() {
        checkNotNull();
        return _getStaticFriction(address);
    }
    private static native float _getStaticFriction(long address);

    /**
     * The static friction coefficient
     */
    public void setStaticFriction(float value) {
        checkNotNull();
        _setStaticFriction(address, value);
    }
    private static native void _setStaticFriction(long address, float value);

    /**
     */
    public byte getMaterialFlags() {
        checkNotNull();
        return _getMaterialFlags(address);
    }
    private static native byte _getMaterialFlags(long address);

    /**
     */
    public void setMaterialFlags(byte value) {
        checkNotNull();
        _setMaterialFlags(address, value);
    }
    private static native void _setMaterialFlags(long address, byte value);

    /**
     * The surface index of shape 1 at the contact point. This is used to identify the surface material.
     * <p>
     * <b>Note:</b> This field is only supported by triangle meshes and heightfields, else it will be set to PXC_CONTACT_NO_FACE_INDEX.
     * <b>Note:</b> This value must be directly after internalFaceIndex0 in memory
     */
    public int getInternalFaceIndex1() {
        checkNotNull();
        return _getInternalFaceIndex1(address);
    }
    private static native int _getInternalFaceIndex1(long address);

    /**
     * The surface index of shape 1 at the contact point. This is used to identify the surface material.
     * <p>
     * <b>Note:</b> This field is only supported by triangle meshes and heightfields, else it will be set to PXC_CONTACT_NO_FACE_INDEX.
     * <b>Note:</b> This value must be directly after internalFaceIndex0 in memory
     */
    public void setInternalFaceIndex1(int value) {
        checkNotNull();
        _setInternalFaceIndex1(address, value);
    }
    private static native void _setInternalFaceIndex1(long address, int value);

    /**
     * The dynamic friction coefficient
     */
    public float getDynamicFriction() {
        checkNotNull();
        return _getDynamicFriction(address);
    }
    private static native float _getDynamicFriction(long address);

    /**
     * The dynamic friction coefficient
     */
    public void setDynamicFriction(float value) {
        checkNotNull();
        _setDynamicFriction(address, value);
    }
    private static native void _setDynamicFriction(long address, float value);

    /**
     * The restitution coefficient
     */
    public float getRestitution() {
        checkNotNull();
        return _getRestitution(address);
    }
    private static native float _getRestitution(long address);

    /**
     * The restitution coefficient
     */
    public void setRestitution(float value) {
        checkNotNull();
        _setRestitution(address, value);
    }
    private static native void _setRestitution(long address, float value);

    /**
     */
    public float getDamping() {
        checkNotNull();
        return _getDamping(address);
    }
    private static native float _getDamping(long address);

    /**
     */
    public void setDamping(float value) {
        checkNotNull();
        _setDamping(address, value);
    }
    private static native void _setDamping(long address, float value);

}
