package physx.extensions;

import physx.NativeObject;

public class PxD6JointDriveFlags extends NativeObject {

    protected PxD6JointDriveFlags() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxD6JointDriveFlags wrapPointer(long address) {
        return address != 0L ? new PxD6JointDriveFlags(address) : null;
    }
    
    public static PxD6JointDriveFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxD6JointDriveFlags(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param flags   WebIDL type: unsigned long
     * @return Stack allocated object of PxD6JointDriveFlags
     */
    public static PxD6JointDriveFlags createAt(long address, int flags) {
        __placement_new_PxD6JointDriveFlags(address, flags);
        PxD6JointDriveFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param flags     WebIDL type: unsigned long
     * @return Stack allocated object of PxD6JointDriveFlags
     */
    public static <T> PxD6JointDriveFlags createAt(T allocator, Allocator<T> allocate, int flags) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxD6JointDriveFlags(address, flags);
        PxD6JointDriveFlags createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxD6JointDriveFlags(long address, int flags);

    // Constructors

    /**
     * @param flags WebIDL type: unsigned long
     */
    public PxD6JointDriveFlags(int flags) {
        address = _PxD6JointDriveFlags(flags);
    }
    private static native long _PxD6JointDriveFlags(int flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxD6JointDriveFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(PxD6JointDriveFlagEnum flag) {
        checkNotNull();
        return _isSet(address, flag.value);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxD6JointDriveFlagEnum} [enum]
     */
    public void raise(PxD6JointDriveFlagEnum flag) {
        checkNotNull();
        _raise(address, flag.value);
    }
    private static native void _raise(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxD6JointDriveFlagEnum} [enum]
     */
    public void clear(PxD6JointDriveFlagEnum flag) {
        checkNotNull();
        _clear(address, flag.value);
    }
    private static native void _clear(long address, int flag);

}
