package physx.common;

import physx.NativeObject;

/**
 * Class to define the scale at which simulation runs. Most simulation tolerances are
 * calculated in terms of the values here. 
 * <p>
 * <b>Note:</b> if you change the simulation scale, you will probably also wish to change the scene's
 * default value of gravity, and stable simulation will probably require changes to the scene's 
 * bounceThreshold also.
 */
public class PxTolerancesScale extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTolerancesScale wrapPointer(long address) {
        return address != 0L ? new PxTolerancesScale(address) : null;
    }
    
    public static PxTolerancesScale arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTolerancesScale(long address) {
        super(address);
    }

    // Constructors

    /**
     * constructor sets to default 
     */
    public PxTolerancesScale() {
        address = _PxTolerancesScale();
    }
    private static native long _PxTolerancesScale();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
