package physx.common;

/**
 * * Possible graphic/CUDA interoperability modes for context
 */
public enum PxCudaInteropModeEnum {

    NO_INTEROP(getNO_INTEROP()),
    D3D10_INTEROP(getD3D10_INTEROP()),
    D3D11_INTEROP(getD3D11_INTEROP()),
    OGL_INTEROP(getOGL_INTEROP());
    public final int value;
    
    PxCudaInteropModeEnum(int value) {
        this.value = value;
    }

    private static native int _getNO_INTEROP();
    private static int getNO_INTEROP() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.common.PxCudaInteropModeEnum");
        return _getNO_INTEROP();
    }

    private static native int _getD3D10_INTEROP();
    private static int getD3D10_INTEROP() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.common.PxCudaInteropModeEnum");
        return _getD3D10_INTEROP();
    }

    private static native int _getD3D11_INTEROP();
    private static int getD3D11_INTEROP() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.common.PxCudaInteropModeEnum");
        return _getD3D11_INTEROP();
    }

    private static native int _getOGL_INTEROP();
    private static int getOGL_INTEROP() {
        de.fabmax.physxjni.Loader.load();
        physx.PlatformChecks.requirePlatform(3, "physx.common.PxCudaInteropModeEnum");
        return _getOGL_INTEROP();
    }

    public static PxCudaInteropModeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxCudaInteropModeEnum: " + value);
    }

}
