package physx.vehicle2;


/**
 * A description of the state of transmission-related commands that are applied to a vehicle with tank drive.
 */
public class PxVehicleTankDriveTransmissionCommandState extends PxVehicleEngineDriveTransmissionCommandState {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTankDriveTransmissionCommandState wrapPointer(long address) {
        return address != 0L ? new PxVehicleTankDriveTransmissionCommandState(address) : null;
    }
    
    public static PxVehicleTankDriveTransmissionCommandState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTankDriveTransmissionCommandState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTankDriveTransmissionCommandState() {
        address = _PxVehicleTankDriveTransmissionCommandState();
    }
    private static native long _PxVehicleTankDriveTransmissionCommandState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getThrusts(int index) {
        checkNotNull();
        return _getThrusts(address, index);
    }
    private static native float _getThrusts(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setThrusts(int index, float value) {
        checkNotNull();
        _setThrusts(address, index, value);
    }
    private static native void _setThrusts(long address, int index, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
