package physx.vehicle2;

import physx.NativeObject;

/**
 * A description of the PhysX models employed to resolve suspension limit constraints.
 * @see PxVehiclePhysXConstraintState
 */
public class PxVehiclePhysXSuspensionLimitConstraintParams extends NativeObject {

    protected PxVehiclePhysXSuspensionLimitConstraintParams() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXSuspensionLimitConstraintParams wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXSuspensionLimitConstraintParams(address) : null;
    }
    
    public static PxVehiclePhysXSuspensionLimitConstraintParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXSuspensionLimitConstraintParams(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * restitution is used by the restitution model used to generate a target velocity when resolving suspension limit
     * constraints.
     * <b>Note:</b> A value of 0.0 means that the restitution model is not employed.
     * <b>Note:</b> Restitution has no effect if directionForSuspensionLimitConstraint has value Enum::eNONE.
     */
    public float getRestitution() {
        checkNotNull();
        return _getRestitution(address);
    }
    private static native float _getRestitution(long address);

    /**
     * restitution is used by the restitution model used to generate a target velocity when resolving suspension limit
     * constraints.
     * <b>Note:</b> A value of 0.0 means that the restitution model is not employed.
     * <b>Note:</b> Restitution has no effect if directionForSuspensionLimitConstraint has value Enum::eNONE.
     */
    public void setRestitution(float value) {
        checkNotNull();
        _setRestitution(address, value);
    }
    private static native void _setRestitution(long address, float value);

    /**
     */
    public PxVehiclePhysXSuspensionLimitConstraintParamsDirectionSpecifierEnum getDirectionForSuspensionLimitConstraint() {
        checkNotNull();
        return PxVehiclePhysXSuspensionLimitConstraintParamsDirectionSpecifierEnum.forValue(_getDirectionForSuspensionLimitConstraint(address));
    }
    private static native int _getDirectionForSuspensionLimitConstraint(long address);

    /**
     */
    public void setDirectionForSuspensionLimitConstraint(PxVehiclePhysXSuspensionLimitConstraintParamsDirectionSpecifierEnum value) {
        checkNotNull();
        _setDirectionForSuspensionLimitConstraint(address, value.value);
    }
    private static native void _setDirectionForSuspensionLimitConstraint(long address, int value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehiclePhysXSuspensionLimitConstraintParams} [Value]
     */
    public PxVehiclePhysXSuspensionLimitConstraintParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehiclePhysXSuspensionLimitConstraintParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
