package physx.vehicle2;

import physx.NativeObject;
import physx.physics.PxQueryFilterCallback;
import physx.physics.PxQueryFilterData;

/**
 * A description of type of PhysX scene query and the filter data to apply to the query.
 */
public class PxVehiclePhysXRoadGeometryQueryParams extends NativeObject {

    protected PxVehiclePhysXRoadGeometryQueryParams() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXRoadGeometryQueryParams wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXRoadGeometryQueryParams(address) : null;
    }
    
    public static PxVehiclePhysXRoadGeometryQueryParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXRoadGeometryQueryParams(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * A description of the type of physx scene query to employ.
     */
    public PxVehiclePhysXRoadGeometryQueryTypeEnum getRoadGeometryQueryType() {
        checkNotNull();
        return PxVehiclePhysXRoadGeometryQueryTypeEnum.forValue(_getRoadGeometryQueryType(address));
    }
    private static native int _getRoadGeometryQueryType(long address);

    /**
     * A description of the type of physx scene query to employ.
     */
    public void setRoadGeometryQueryType(PxVehiclePhysXRoadGeometryQueryTypeEnum value) {
        checkNotNull();
        _setRoadGeometryQueryType(address, value.value);
    }
    private static native void _setRoadGeometryQueryType(long address, int value);

    /**
     * The filter data to use for the physx scene query.
     */
    public PxQueryFilterData getFilterData() {
        checkNotNull();
        return PxQueryFilterData.wrapPointer(_getFilterData(address));
    }
    private static native long _getFilterData(long address);

    /**
     * The filter data to use for the physx scene query.
     */
    public void setFilterData(PxQueryFilterData value) {
        checkNotNull();
        _setFilterData(address, value.getAddress());
    }
    private static native void _setFilterData(long address, long value);

    /**
     * A filter callback to be used by the physx scene query
     * <b>Note:</b> A null pointer is allowed.
     */
    public PxQueryFilterCallback getFilterCallback() {
        checkNotNull();
        return PxQueryFilterCallback.wrapPointer(_getFilterCallback(address));
    }
    private static native long _getFilterCallback(long address);

    /**
     * A filter callback to be used by the physx scene query
     * <b>Note:</b> A null pointer is allowed.
     */
    public void setFilterCallback(PxQueryFilterCallback value) {
        checkNotNull();
        _setFilterCallback(address, value.getAddress());
    }
    private static native void _setFilterCallback(long address, long value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehiclePhysXRoadGeometryQueryParams} [Value]
     */
    public PxVehiclePhysXRoadGeometryQueryParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehiclePhysXRoadGeometryQueryParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
