package physx.vehicle2;

import physx.NativeObject;

/**
 * A description of the state of transmission-related commands that are applied to a vehicle with engine drive.
 */
public class PxVehicleEngineDriveTransmissionCommandState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleEngineDriveTransmissionCommandState wrapPointer(long address) {
        return address != 0L ? new PxVehicleEngineDriveTransmissionCommandState(address) : null;
    }
    
    public static PxVehicleEngineDriveTransmissionCommandState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleEngineDriveTransmissionCommandState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleEngineDriveTransmissionCommandState() {
        address = _PxVehicleEngineDriveTransmissionCommandState();
    }
    private static native long _PxVehicleEngineDriveTransmissionCommandState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The instantaneous state of the clutch controller in range [0,1] with 1 denoting fully pressed and 0 fully depressed.
     */
    public float getClutch() {
        checkNotNull();
        return _getClutch(address);
    }
    private static native float _getClutch(long address);

    /**
     * The instantaneous state of the clutch controller in range [0,1] with 1 denoting fully pressed and 0 fully depressed.
     */
    public void setClutch(float value) {
        checkNotNull();
        _setClutch(address, value);
    }
    private static native void _setClutch(long address, float value);

    /**
     * The desired gear of the input gear controller.
     */
    public int getTargetGear() {
        checkNotNull();
        return _getTargetGear(address);
    }
    private static native int _getTargetGear(long address);

    /**
     * The desired gear of the input gear controller.
     */
    public void setTargetGear(int value) {
        checkNotNull();
        _setTargetGear(address, value);
    }
    private static native void _setTargetGear(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
