package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleDifferentialState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleDifferentialState wrapPointer(long address) {
        return address != 0L ? new PxVehicleDifferentialState(address) : null;
    }
    
    public static PxVehicleDifferentialState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleDifferentialState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDifferentialState() {
        address = _PxVehicleDifferentialState();
    }
    private static native long _PxVehicleDifferentialState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getConnectedWheels(int index) {
        checkNotNull();
        return _getConnectedWheels(address, index);
    }
    private static native int _getConnectedWheels(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setConnectedWheels(int index, int value) {
        checkNotNull();
        _setConnectedWheels(address, index, value);
    }
    private static native void _setConnectedWheels(long address, int index, int value);

    /**
     * The number of wheels that are connected to the differential.
     */
    public int getNbConnectedWheels() {
        checkNotNull();
        return _getNbConnectedWheels(address);
    }
    private static native int _getNbConnectedWheels(long address);

    /**
     * The number of wheels that are connected to the differential.
     */
    public void setNbConnectedWheels(int value) {
        checkNotNull();
        _setNbConnectedWheels(address, value);
    }
    private static native void _setNbConnectedWheels(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getTorqueRatiosAllWheels(int index) {
        checkNotNull();
        return _getTorqueRatiosAllWheels(address, index);
    }
    private static native float _getTorqueRatiosAllWheels(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setTorqueRatiosAllWheels(int index, float value) {
        checkNotNull();
        _setTorqueRatiosAllWheels(address, index, value);
    }
    private static native void _setTorqueRatiosAllWheels(long address, int index, float value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getAveWheelSpeedContributionAllWheels(int index) {
        checkNotNull();
        return _getAveWheelSpeedContributionAllWheels(address, index);
    }
    private static native float _getAveWheelSpeedContributionAllWheels(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setAveWheelSpeedContributionAllWheels(int index, float value) {
        checkNotNull();
        _setAveWheelSpeedContributionAllWheels(address, index, value);
    }
    private static native void _setAveWheelSpeedContributionAllWheels(long address, int index, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
