package physx.vehicle2;

import physx.NativeObject;

/**
 * A description of a single axle that is to be affected by Ackermann steer correction.
 */
public class PxVehicleAckermannParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleAckermannParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleAckermannParams(address) : null;
    }
    
    public static PxVehicleAckermannParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleAckermannParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleAckermannParams() {
        address = _PxVehicleAckermannParams();
    }
    private static native long _PxVehicleAckermannParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getWheelIds(int index) {
        checkNotNull();
        return _getWheelIds(address, index);
    }
    private static native int _getWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setWheelIds(int index, int value) {
        checkNotNull();
        _setWheelIds(address, index, value);
    }
    private static native void _setWheelIds(long address, int index, int value);

    /**
     * wheelBase is the longitudinal distance between the axle that is affected by Ackermann correction and a reference axle.
     */
    public float getWheelBase() {
        checkNotNull();
        return _getWheelBase(address);
    }
    private static native float _getWheelBase(long address);

    /**
     * wheelBase is the longitudinal distance between the axle that is affected by Ackermann correction and a reference axle.
     */
    public void setWheelBase(float value) {
        checkNotNull();
        _setWheelBase(address, value);
    }
    private static native void _setWheelBase(long address, float value);

    /**
     * trackWidth is the width of the axle specified by #wheelIds
     */
    public float getTrackWidth() {
        checkNotNull();
        return _getTrackWidth(address);
    }
    private static native float _getTrackWidth(long address);

    /**
     * trackWidth is the width of the axle specified by #wheelIds
     */
    public void setTrackWidth(float value) {
        checkNotNull();
        _setTrackWidth(address, value);
    }
    private static native void _setTrackWidth(long address, float value);

    /**
     * is the strength of the correction with 0 denoting no correction and 1 denoting perfect correction.
     */
    public float getStrength() {
        checkNotNull();
        return _getStrength(address);
    }
    private static native float _getStrength(long address);

    /**
     * is the strength of the correction with 0 denoting no correction and 1 denoting perfect correction.
     */
    public void setStrength(float value) {
        checkNotNull();
        _setStrength(address, value);
    }
    private static native void _setStrength(long address, float value);

    // Functions

    /**
     * @param axleDesc WebIDL type: {@link PxVehicleAxleDescription} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean isValid(PxVehicleAxleDescription axleDesc) {
        checkNotNull();
        return _isValid(address, axleDesc.getAddress());
    }
    private static native boolean _isValid(long address, long axleDesc);

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleAckermannParams} [Value]
     */
    public PxVehicleAckermannParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleAckermannParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

}
