package physx.vehicle2;

import physx.NativeObject;

public class DirectDrivetrainParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static DirectDrivetrainParams wrapPointer(long address) {
        return address != 0L ? new DirectDrivetrainParams(address) : null;
    }
    
    public static DirectDrivetrainParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected DirectDrivetrainParams(long address) {
        super(address);
    }

    // Constructors

    public DirectDrivetrainParams() {
        address = _DirectDrivetrainParams();
    }
    private static native long _DirectDrivetrainParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleDirectDriveThrottleCommandResponseParams} [Value]
     */
    public PxVehicleDirectDriveThrottleCommandResponseParams getDirectDriveThrottleResponseParams() {
        checkNotNull();
        return PxVehicleDirectDriveThrottleCommandResponseParams.wrapPointer(_getDirectDriveThrottleResponseParams(address));
    }
    private static native long _getDirectDriveThrottleResponseParams(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDirectDriveThrottleCommandResponseParams} [Value]
     */
    public void setDirectDriveThrottleResponseParams(PxVehicleDirectDriveThrottleCommandResponseParams value) {
        checkNotNull();
        _setDirectDriveThrottleResponseParams(address, value.getAddress());
    }
    private static native void _setDirectDriveThrottleResponseParams(long address, long value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link DirectDrivetrainParams} [Value]
     */
    public DirectDrivetrainParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return DirectDrivetrainParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @param axleDesc WebIDL type: {@link PxVehicleAxleDescription} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean isValid(PxVehicleAxleDescription axleDesc) {
        checkNotNull();
        return _isValid(address, axleDesc.getAddress());
    }
    private static native boolean _isValid(long address, long axleDesc);

}
