package physx.support;

import physx.NativeObject;
import physx.geometry.PxHeightFieldSample;

public class Vector_PxHeightFieldSample extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static Vector_PxHeightFieldSample wrapPointer(long address) {
        return address != 0L ? new Vector_PxHeightFieldSample(address) : null;
    }
    
    public static Vector_PxHeightFieldSample arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected Vector_PxHeightFieldSample(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxHeightFieldSample() {
        address = _Vector_PxHeightFieldSample();
    }
    private static native long _Vector_PxHeightFieldSample();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxHeightFieldSample(int size) {
        address = _Vector_PxHeightFieldSample(size);
    }
    private static native long _Vector_PxHeightFieldSample(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxHeightFieldSample} [Ref]
     */
    public PxHeightFieldSample at(int index) {
        checkNotNull();
        return PxHeightFieldSample.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link PxHeightFieldSample}
     */
    public PxHeightFieldSample data() {
        checkNotNull();
        return PxHeightFieldSample.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxHeightFieldSample} [Ref]
     */
    public void push_back(PxHeightFieldSample value) {
        checkNotNull();
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
