package physx.support;

import physx.NativeObject;
import physx.physics.PxArticulationReducedCoordinate;
import physx.physics.PxRigidActor;
import physx.physics.PxScene;
import physx.physics.PxShape;

public class SupportFunctions extends NativeObject {

    protected SupportFunctions() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static SupportFunctions wrapPointer(long address) {
        return address != 0L ? new SupportFunctions(address) : null;
    }
    
    public static SupportFunctions arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected SupportFunctions(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param actor WebIDL type: {@link PxRigidActor} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxShape}
     */
    public static PxShape PxActor_getShape(PxRigidActor actor, int index) {
        return PxShape.wrapPointer(_PxActor_getShape(actor.getAddress(), index));
    }
    private static native long _PxActor_getShape(long actor, int index);

    /**
     * @param scene WebIDL type: {@link PxScene}
     * @return WebIDL type: {@link Vector_PxActorPtr} [Ref]
     */
    public static Vector_PxActorPtr PxScene_getActiveActors(PxScene scene) {
        return Vector_PxActorPtr.wrapPointer(_PxScene_getActiveActors(scene.getAddress()));
    }
    private static native long _PxScene_getActiveActors(long scene);

    /**
     * @param articulation WebIDL type: {@link PxArticulationReducedCoordinate}
     * @return WebIDL type: unsigned long
     */
    public static int PxArticulationReducedCoordinate_getMinSolverPositionIterations(PxArticulationReducedCoordinate articulation) {
        return _PxArticulationReducedCoordinate_getMinSolverPositionIterations(articulation.getAddress());
    }
    private static native int _PxArticulationReducedCoordinate_getMinSolverPositionIterations(long articulation);

    /**
     * @param articulation WebIDL type: {@link PxArticulationReducedCoordinate}
     * @return WebIDL type: unsigned long
     */
    public static int PxArticulationReducedCoordinate_getMinSolverVelocityIterations(PxArticulationReducedCoordinate articulation) {
        return _PxArticulationReducedCoordinate_getMinSolverVelocityIterations(articulation.getAddress());
    }
    private static native int _PxArticulationReducedCoordinate_getMinSolverVelocityIterations(long articulation);

}
